<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
require APPPATH . '/libraries/Paginado.php';

include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Datos1_ii extends REST_Controller
{


    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }

         $this->load->model('Datos1_ii_model');
    }


 
    public function agregar1_ii_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos1_ii_model->agregar1_ii($post);
        $this->response($respuesta, $respuesta['status']);
    }


    public function formato1_ii_get()
    {
        $respuesta = $this->Datos1_ii_model->obtener1_ii($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function index_get()
    {
        $respuesta = $this->Datos1_ii_model->obtenerTiposSector();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }




    public function formato1_ii_add_get()
    {
        $respuesta = $this->Datos1_ii_model->obtener1_ii_add($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function index_post()
    {
        $respuesta = $this->Datos1_ii_model->obtener_add($this->post('idformato'), $this->post('idparticipacion'));
        $this->response($respuesta);
    }

    public function agregar1_ii_add_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos1_ii_model->agregar1_ii_add($post);
        $this->response($respuesta, $respuesta['status']);
    }

    public function baja_add_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos1_ii_model->bajaPrestamo($post);
        $this->response($respuesta, $respuesta['status']);
    }



  
}
