<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
require APPPATH . '/libraries/Paginado.php';

include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Datos5 extends REST_Controller
{


    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }

         $this->load->model('Datos5_model');
    }


 
    public function agregar5_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos5_model->agregar5($post);
        $this->response($respuesta, $respuesta['status']);
    }


    public function formato5_get()
    {
        $respuesta = $this->Datos5_model->obtener5($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function agregar5_ii_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos5_model->agregar5_ii($post);
        $this->response($respuesta, $respuesta['status']);
    }


    public function formato5_ii_get()
    {
        $respuesta = $this->Datos5_model->obtener5_ii($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function index_get()
    {
        $respuesta = $this->Datos5_model->obtenerTiposSector();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }




    //Adicionales
    public function formato5_ii_add_get()
    {
        $respuesta = $this->Datos5_model->obtener5_ii_add($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function index_post()
    {
        $respuesta = $this->Datos5_model->obtener_add($this->post('idformato'), $this->post('idcliente'));
        $this->response($respuesta);
    }

    public function agregar5_ii_add_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos5_model->agregar5_ii_add($post);
        $this->response($respuesta, $respuesta['status']);
    }

    public function baja_add_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos5_model->bajaCliente($post);
        $this->response($respuesta, $respuesta['status']);
    }
}
