<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Documentos extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }
        $this->load->model('documentos_model');
    }


 

    public function agregar_post()
    {
        $this->load->model('documentos_model');
        $data = (array) json_decode($this->post('data'));
        $respuesta = $this->documentos_model->agregarRegistro($data, $this->post());
        $this->response($respuesta, $respuesta['status']);
    }

    public function agregar_pdf_post()
    {
        $this->load->model('documentos_model');
        $data = (array) json_decode($this->post('data'));
        $respuesta = $this->documentos_model->agregarDocumentoPdf($data, $this->post());
        $this->response($respuesta, $respuesta['status']);
    }

    public function documentospag_post()
    {
        $this->load->model('documentos_model');
        $respuesta = $this->documentos_model->paginado($this->post());
        $this->response($respuesta);
    }

    public function declaracionespag_post()
    {
        $this->load->model('documentos_model');
        $respuesta = $this->documentos_model->paginadoDeclaraciones($this->post());
        $this->response($respuesta);
    }
    // Obtener el paginador
    // public function registrospag_post()
    // {
    //     $this->load->model('documentos_model');
    //     $respuesta = $this->documentos_model->paginado($this->post());
    //     $this->response($respuesta["respuesta"], $respuesta["status"]);
    // }

    public function paginado_post()
    {
        $this->load->model('formato_model');
        $respuesta = $this->formato_model->paginado($this->post());
        $this->response($respuesta);
    }

    
    public function eliminar_doc_post()
    {
        $this->load->model('documentos_model');
        $respuesta = $this->documentos_model->eliminar_doc($this->post());
        $this->response($respuesta);
    }

    public function eliminar_docpdf_post()
    {
        $this->load->model('documentos_model');
        $respuesta = $this->documentos_model->eliminar_docpdf($this->post());
        $this->response($respuesta);
    }


    public function archivos_get()
    {
        $this->load->model('documentos_model');
        $respuesta = $this->documentos_model->consultar($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function Doc_get()
    {
        $respuesta = $this->documentos_model->consultaDocumentos($this->get());
        $this->response($respuesta, $respuesta['status']);
    }




    public function trimestres_post()
    {
        $this->load->model('documentos_model');
        $respuesta = $this->documentos_model->paginadoTrimestres($this->post());
        $this->response($respuesta);
    }


  

    public function trimestre_post()
    {
        $respuesta = $this->documentos_model->consultaTrimestre($this->post('where'), $this->post('view'));
        $this->response($respuesta);
    }
}