<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
require APPPATH . '/libraries/Paginado.php';

include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Formato extends REST_Controller
{


    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }

         $this->load->model('formato_model');
    }

  

    public function obtener_reporte_post()
    {
        $this->load->model('formato_model');
        $this->formato_model->obtenerReportePDF($this->post('idformato'));
    }
    public function pdf_plantilla_post()
    {
        $this->load->helper("pdf_plantilla");
        pdf_plantilla($this->post());
    }

    public function pdf_plantillatest_post()
    {
        $this->load->helper("test/pdf_plantillatest");
        pdf_plantillatest($this->post());
    }

    public function pdf_plantillatestmod_post()
    {
        $this->load->helper("test/pdf_plantillatestmod");
        pdf_plantillatestmod($this->post());
    }


    public function pdf_plantillatestcon_post()
    {
        $this->load->helper("test/pdf_plantillatestcon");
        pdf_plantillatestcon($this->post());
    }


    public function pdf_acuse_post()
    {
        $this->load->helper("pdf_acuse");
        pdf_acuse($this->post());
    }

    public function pdf_acuse2023_post()
    {
        $this->load->helper("pdf_acuse2023");
        pdf_acuse2023($this->post());
    }

    public function pdf_acuse2024_post()
    {
        $this->load->helper("pdf_acuse2024");
        pdf_acuse2024($this->post());
    }


    public function pdf_plantillainicial_post()
    {
        $this->load->helper("pdf_plantillainicial");
        pdf_plantillainicial($this->post());
    }

    public function pdf_plantillaconclusion_post()
    {
        $this->load->helper("pdf_plantillaconclusion");
        pdf_plantillaconclusion($this->post());
    } 
 // Función para obtener la lista de los tipos de inspec
    public function tiposinspector_get()
    {
        $respuesta = $this->infracciones_model->obtenerTiposDeInspector($this->post());
        $this->response($respuesta);
    }

    public function tipos_get()
    {
        $respuesta = $this->infracciones_model->TiposDeInspector($this->post());
        $this->response($respuesta);
    }

    public function agregar_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->formato_model->agregarFormato($post);
        $this->response($respuesta);
    }

    public function agregar3_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->formato_model->agregar3($post);
        $this->response($respuesta, $respuesta['status']);
    }



    public function formato_get()
    {
        $respuesta = $this->formato_model->obtenerFormato($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function tipo_formato_get()
    {
        $respuesta = $this->formato_model->obtenerTipoFormato($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    // public function formato3_get()
    // {
    //     $respuesta = $this->formato_model->obtener3($this->get());
    //     $this->response($respuesta, $respuesta['status']);
    // }

    // Obtener el paginador
    public function paginado_post()
    {
        $this->load->model('formato_model');
        $respuesta = $this->formato_model->paginado($this->post());
        $this->response($respuesta);
    }



    // Obtener el paginador
    public function formatospag_post()
    {
        $this->load->model('formato_model');
        $respuesta = $this->formato_model->paginado($this->post());
        $this->response($respuesta);


        // Creando el objeto validador
        $validador = new Validador_helper();
        $esValido = $validador->validarUsuarioM($this->post());

        if (!$esValido["status"]) {
            $this->response($esValido["mensaje"], REST_Controller::HTTP_UNPROCESSABLE_ENTITY);
        } else {
            $modeloFormato = new formato_model();

            // Obteniendo la respuesta de la funcion
            $respuesta = $modeloFormato->agregarFormato($this->post());

            // Si el codigo de la respuesta es 200 HTTP_OK
            if ($respuesta["status"] == 200) {
                // Devolvemos el mensaje de respuesta
                $this->response($respuesta["mensaje"], REST_Controller::HTTP_OK);
            }

            // De lo contrario
            else {
                // Devolviendo el mensaje de respuesta con un codigo 422 HTTP_UNPROCESSABLE_ENTITY
                $this->response($respuesta["mensaje"], REST_Controller::HTTP_UNPROCESSABLE_ENTITY);
            }
        }
    }


    public function index_post()
    {
         $respuesta = $this->formato_model->obtenerProgreso($this->post('idformato'));
           $this->response($respuesta);

    }
    public function tipousuario_post()
    {
        $respuesta = $this->formato_model->obtenerTipoUsuario($this->post('idusuario'));
        $this->response($respuesta);
    }

    public function tiposusuario_post()
    {
        $respuesta = $this->formato_model->tiposUsuario($this->post('idusuario'));
        $this->response($respuesta);
    }

    public function index_get()
    {
        $respuesta = $this->formato_model->obtenerSecciones();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }


     public function nivel_post()
    {
         $respuesta = $this->formato_model->obtenerNivel($this->post('idusuario'));
           $this->response($respuesta);

    }


    public function enviar_post()
    {
        $respuesta = $this->formato_model->Enviar($this->post('idformato'));
        $this->response($respuesta);
    }

    public function enviar_conclusion_post()
    {
        $respuesta = $this->formato_model->EnviarConclusion($this->post('idformato'));
        $this->response($respuesta);
    }

    public function str_get()
    {
        $respuesta = $this->formato_model->CadenaStr($this->get());
        $this->response($respuesta, $respuesta['status']);
    }
    public function filtro_get()
    {
        $respuesta = $this->formato_model->obtenerFiltro($this->get());
        $this->response($respuesta, $respuesta['status']);
    }


    public function reporte_get()
    {
        $respuesta = $this->formato_model->Reporte($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function reporte22_23_get()
    {
        $respuesta = $this->formato_model->Reporte22_23($this->get());
        $this->response($respuesta, $respuesta['status']);
    }


    public function reporteadd_get()
    {
        $respuesta = $this->formato_model->Reporte_add($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function tipossector_get()
    {
        $respuesta = $this->formato_model->obtenerTiposSector();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }


    public function cambiar_estado_put()
    {
        $this->load->model('formato_model');
        $respuesta = $this->formato_model->cambiar_estado($this->put());
        $status = $respuesta['status'];
        $this->response($respuesta, $status);
    }

    public function reporteadd_2_get()
    {
        $respuesta = $this->formato_model->Reporte_add_2($this->get());
        $this->response($respuesta, $respuesta['status']);
    }
}
