<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla6ii_add($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $y = 1;
    $where = array('idformato' => $idformato);
    $query7 = $CI->db->get_where('6_ii_beneficios_add', $where, 1);
    $codigo_6ii_add = $query7->row();
    $pdf->SetTextColor(0, 0, 0);

    $CI->db->select('*')->from('6_ii_beneficios_add')->where('idformato', $idformato)->where('activo', 1);
    $consulta = $CI->db->get()->result_array();
    $lenght = count($consulta) - 1;

    for ($x = 0; $x <= $lenght; $x++) {
        $datos = array(
            $id = $consulta[$x]['idbeneficio'],
            'idbeneficio' => $consulta[$x]['idbeneficio'],
            'tipo_beneficio' => $consulta[$x]['tipo_beneficio'],
            'beneficiario' => $consulta[$x]['beneficiario'],
            'otorgante' => $consulta[$x]['otorgante'],
            'nombre_otorgante' => $consulta[$x]['nombre_otorgante'],
            'rfc' => $consulta[$x]['rfc'],
            'forma_recepcion' => $consulta[$x]['forma_recepcion'],
            'beneficio' => $consulta[$x]['beneficio'],
            'monto_mensual' => $consulta[$x]['monto_mensual'],
            'tipo_moneda' => $consulta[$x]['tipo_moneda'],
            'sector_productivo' => $consulta[$x]['sector_productivo'],
            'sector_productivo_esp' => $consulta[$x]['sector_productivo_esp'],
            'tipo_beneficio_esp' => $consulta[$x]['tipo_beneficio_esp'],
            'aclaraciones' => $consulta[$x]['aclaraciones'],

        );

        $where = array('idformato' => $idformato, 'idbeneficio' => $id);
        $CI->db->select('tipos_sector.nombre as nombre');
        $CI->db->from('6_ii_beneficios_add');
        $CI->db->join('tipos_sector', '6_ii_beneficios_add.sector_productivo=tipos_sector.idtipo_sector');
        $CI->db->where($where);;
        $query = $CI->db->get();
        $view_tipos6 = $query->row();
        $y++;
        if ($codigo_6ii_add->idformato == $idformato) {

            $pdf->setSourceFile('plantillas/II_Declaracion_Intereses/II_6_Beneficios.pdf');
            $pdf->AddPage();
            $tplIdx = $pdf->importPage(1);
            $pdf->useTemplate($tplIdx, 0, 0);

            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetTextColor(255, 255, 255);
            $pdf->SetFillColor(122, 70, 100);
            $pdf->SetY(25);
            $pdf->SetX(176);
            $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
            $pdf->SetY(32);
            $pdf->SetX(176);
            $pdf->MultiCell(26, 6, utf8_decode('NÚMERO # ' . $y), 0, 0, true);
            $pdf->SetTextColor(0, 0, 0);

            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY(62);
            $pdf->SetX(13);
            if ($datos["tipo_beneficio"] == 'OTRO / ESPECIFIQUE') {
                $pdf->Cell(92, 4, utf8_decode($datos["tipo_beneficio_esp"]));
            } else {
                $pdf->Cell(92, 4, utf8_decode($datos["tipo_beneficio"]));
            }
            $pdf->Ln(10);
            $pdf->SetX(13);
            $pdf->Cell(92, 4, utf8_decode($datos["beneficiario"]));
            $pdf->Ln(10);
            $pdf->SetX(13);
            $pdf->Cell(50, 4, utf8_decode($datos["otorgante"]));
            $pdf->Ln(10);
            $pdf->SetX(13);
            $pdf->Cell(80, 4, utf8_decode($datos["nombre_otorgante"]));
            $pdf->Ln(10);
            $pdf->SetX(13);
            $pdf->Cell(95, 4, utf8_decode($datos["rfc"]));
            $pdf->Cell(80, 4, utf8_decode($datos["forma_recepcion"]));
            $pdf->Ln(10.5);
            $pdf->SetX(13);
            $pdf->Cell(124, 4, utf8_decode($datos["beneficio"]));
            $pdf->Ln(10);
            $pdf->SetX(13);
            $pdf->Cell(95, 4, utf8_decode($datos["monto_mensual"]));
            $pdf->Cell(80, 4, utf8_decode($datos["tipo_moneda"]));
            $pdf->Ln(9.5);
            $pdf->SetX(13);
            if ($datos["sector_productivo"] == '17') {
                $pdf->Cell(110, 4, utf8_decode($datos["sector_productivo_esp"]));
            } else {
                if ($view_tipos6 != null) {
                    $pdf->Cell(110, 4, utf8_decode($view_tipos6->nombre));
                }
            }
            $pdf->SetY(141.5);
            $pdf->SetX(13);
            $pdf->MultiCell(184, 3.5, utf8_decode($datos["aclaraciones"]));

        }
    }

}

