<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";

    //13. ADEUDOS / PASIVOS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function plantilla13($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('13_adeudos', $where, 1);
    $codigo_13 = $query->row();

    //View tipos Declarante  13. Adeudos
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_declarante.nombre as nombre');
    $CI->db->from('13_adeudos');
    $CI->db->join('tipos_declarante', '13_adeudos.titular_adeudo=tipos_declarante.idtipo');
    $CI->db->where($where);;
    $query = $CI->db->get();
    $view_declarante13 = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();

    // $pdf->setSourceFile('plantillas/Adeudos_13.pdf');
    // $pdf->AddPage();
    // $tplIdx = $pdf->importPage(1);
    // $pdf->useTemplate($tplIdx, 0, 0);

    if ($codigo_13->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.3, 25.4, 4, 4);
    }
    //SIN CAMBIO--SOLO PARA FORMATO MOD
    if ($codigo_13->ninguno == '2' && $codigo->tipo_formato !=1) {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.6, 19, 4, 4);
    }

    if ($codigo->tipo_formato == 3) {
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(24);
        $pdf->SetX(15);
        $pdf->MultiCell(140, 5, utf8_decode('(SITUACIÓN ACTUAL)'), 0, '', true); 
    }
    //AGREGO POR LO MENOS 1
    if ($codigo_13->ninguno == '0') {
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(24);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # 1'), 0, 0, true);
    } 
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetY(56);
    $pdf->SetX(50);
    //  $pdf->Cell(92, 4, utf8_decode($codigo_13->tipo_adeudo));
    if ($codigo_13->tipo_adeudo == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(60, 4, utf8_decode($codigo_13->tipo_adeudo_esp));
    } else {
        $pdf->Cell(60, 4, utf8_decode($codigo_13->tipo_adeudo));
    }
    $pdf->Ln(5);
    $pdf->SetX(50);
    if ($view_declarante13 != null) {
        $pdf->Cell(124, 4, utf8_decode($view_declarante13->nombre));
    }

    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_13->numero_cuenta));
    $pdf->Cell(92, 4, utf8_decode($codigo_13->fecha_adquisicion));
    $pdf->Ln(13);
    $pdf->SetX(13);
    $pdf->Cell(45, 4, utf8_decode($codigo_13->monto_adeudo));
    $pdf->Cell(90, 4, utf8_decode($codigo_13->tipo_moneda));
    $pdf->Cell(42, 4, utf8_decode($codigo_13->saldo));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(45, 4, utf8_decode($codigo_13->tercero));
    $pdf->Cell(97, 4, utf8_decode($codigo_13->nombre_tercero));
    $pdf->Cell(42, 4, utf8_decode($codigo_13->rfc_tercero));
    $pdf->Ln(11);
    $pdf->SetX(13);
    $pdf->Cell(45, 4, utf8_decode($codigo_13->otorgante));
    $pdf->Cell(97, 4, utf8_decode($codigo_13->nombre_otorgante));
    $pdf->Cell(42, 4, utf8_decode($codigo_13->rfc_otorgante));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_13->mexico_extranjero));

    if ($codigo_13->mexico_extranjero == 'EN EL EXTRANJERO') {
        $pdf->SetX(70);
        $pdf->Cell(92, 4, '[' . utf8_decode($codigo_13->pais) . ']');
    }

    $pdf->SetY(124);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_13->aclaraciones));
}

