<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla14($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('14_prestamos', $where, 1);
    $codigo_14 = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();

    // $pdf->setSourceFile('plantillas/Prestamo_14.pdf');
    // $pdf->AddPage();
    // $tplIdx = $pdf->importPage(1);
    // $pdf->useTemplate($tplIdx, 0, 0);
    //14. PRESTAMO O COMODATO POR TERCEROS
    if ($codigo_14->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.8, 27.3, 4, 4);
    }
    //SIN CAMBIO--SOLO PARA FORMATO MOD
    if ($codigo_14->ninguno == '2' && $codigo->tipo_formato !=1) {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.9, 20.9, 4, 4);
    }
    if($codigo->tipo_formato==3){
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(26);
        $pdf->SetX(15);
        $pdf->MultiCell(140, 5, utf8_decode('(SITUACIÓN ACTUAL)'), 0, '', true); 
    }
    //AGREGO POR LO MENOS 1
    if ($codigo_14->ninguno == '0') {
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(26);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # 1'), 0, 0, true);
    } 
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetTextColor(0, 0, 0);

    if ($codigo_14->vehiculo == '1') {
        $logo = SERVIDOR . APP . 'application/images/check.png';
        $pdf->Image($logo, 34.3, 121.8, 4, 4);
    } else {
        $logo = SERVIDOR . APP . 'application/images/remove.png';
        $pdf->Image($logo, 34.3, 121.8, 4, 4);;
    }

    if ($codigo_14->inmueble == '1') {
        $logo = SERVIDOR . APP . 'application/images/check.png';
        $pdf->Image($logo, 34.1, 65, 4, 4);
    } else {
        $logo = SERVIDOR . APP . 'application/images/remove.png';
        $pdf->Image($logo, 34.1, 65, 4, 4);
    }

    $pdf->SetY(70);
    $pdf->SetX(44);
    if ($codigo_14->tipo_bien == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(154, 4, utf8_decode($codigo_14->tipo_bien_esp));
    } else {
        $pdf->Cell(154, 4, utf8_decode($codigo_14->tipo_bien));
    }

    $pdf->Ln(9.5);
    $pdf->SetX(105);
    $pdf->Cell(92, 4, utf8_decode($codigo_14->mexico_extranjero));
    $pdf->Ln(13);
    $pdf->SetX(13);
    $pdf->Cell(70, 4, utf8_decode($codigo_14->calle));
    $pdf->Cell(18, 4, utf8_decode($codigo_14->numero_ext));
    $pdf->Cell(18, 4, utf8_decode($codigo_14->numero_int));
    $pdf->Cell(70, 4, utf8_decode($codigo_14->localidad));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(80, 4, utf8_decode($codigo_14->municipio_estado));
    $pdf->Cell(76, 4, utf8_decode($codigo_14->entidad_pais));
    $pdf->Cell(28, 4, utf8_decode($codigo_14->codigo_postal));
    $pdf->Ln(16);
    $pdf->SetX(152);
    $pdf->Cell(45, 4, utf8_decode($codigo_14->mexico_extranjero2));
    $pdf->Ln(6.5);
    $pdf->SetX(44);


    if ($codigo_14->tipo_vehiculo == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(42, 4, utf8_decode($codigo_14->tipo_vehiculo_esp));
    } else {
        $pdf->Cell(42, 4, utf8_decode($codigo_14->tipo_vehiculo));
    }
    $pdf->SetX(125);
    $pdf->Cell(75, 4, utf8_decode($codigo_14->entidad_pais_registro));
    $pdf->Ln(11);
    $pdf->SetX(13);
    $pdf->Cell(48, 4, utf8_decode($codigo_14->marca));
    $pdf->Cell(46, 4, utf8_decode($codigo_14->modelo));
    $pdf->Cell(43, 4, utf8_decode($codigo_14->anio));
    $pdf->Cell(49, 4, utf8_decode($codigo_14->numero_serie));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(48, 4, utf8_decode($codigo_14->titular));
    $pdf->Cell(136, 4, utf8_decode($codigo_14->nombre_titular));
    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->Cell(48, 4, utf8_decode($codigo_14->rfc_titular));
    $pdf->Cell(136, 4, utf8_decode($codigo_14->relacion_titular));
    $pdf->SetY(164.5);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_14->aclaraciones));

    $pdf->SetFont('Arial', 'B', 8);
    if ($codigo_14->mexico_extranjero2 == 'EN EL EXTRANJERO') {
        $pdf->Text(90, 128, utf8_decode('PAÍS'));
    } else {
        $pdf->Text(90, 128, utf8_decode('ENTIDAD FEDERATIVA'));
    }


    $pdf->SetFont('Arial', 'B', 8);
    if ($codigo_14->mexico_extranjero == 'EN EL EXTRANJERO') {
        $pdf->Text(145, 91, 'CIUDAD/LOCALIDAD');
        $pdf->Text(37, 100, 'ESTADO/PROVINCIA');
        $pdf->Text(114, 100, utf8_decode('PAÍS'));
    } else {
        $pdf->Text(145, 91, 'COLONIA/LOCALIDAD');
        $pdf->Text(37, 100, utf8_decode('MUNICIPIO/ALCALDÍA'));
        $pdf->Text(114, 100, utf8_decode('ENTIDAD FEDERATIVA'));
    }
    $pdf->SetFont('Arial', '', 8);

}

