<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla3ii($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('3_ii_apoyos', $where, 1);
    $codigo_3_ii = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();

    //II- DECLARACIÓN DE INTERESES
    //II- 3.APOYOS O BENEFICIOS PÚBLICOS
    if ($codigo_3_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.3, 30.5, 4, 4);
    }
    //SIN CAMBIO--SOLO PARA FORMATO MOD
    if ($codigo_3_ii->ninguno == '2') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.5, 23.8, 4, 4);
    }
    //FORMATO INICIAL
    if ($codigo->tipo_formato == 1) {
        $pdf->SetY(23);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
    }
    //AGREGO POR LO MENOS 1
    if ($codigo_3_ii->ninguno == '0') {
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(30);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # 1'), 0, 0, true);
    } 

    $pdf->SetFont('Arial', '', 8);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetY(59);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_3_ii->beneficiario));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(73, 4, utf8_decode($codigo_3_ii->nombre_programa));
    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->Cell(64, 4, utf8_decode($codigo_3_ii->institucion));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(47, 4, utf8_decode($codigo_3_ii->nivel_gobierno));
    $pdf->Ln(9);
    $pdf->SetX(13);
    if ($codigo_3_ii->tipo_apoyo == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(85, 4, utf8_decode($codigo_3_ii->tipo_apoyo_esp));
    } else {
        $pdf->Cell(85, 4, utf8_decode($codigo_3_ii->tipo_apoyo));
    }
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(95, 4, utf8_decode($codigo_3_ii->forma_recepcion));
    $pdf->Cell(80, 4, utf8_decode($codigo_3_ii->monto_apoyo));
    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->MultiCell(140, 3.5, utf8_decode($codigo_3_ii->especifique_apoyo));
    $pdf->SetY(125);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_3_ii->aclaraciones));

}

