<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla4ii($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('4_ii_representacion', $where, 1);
    $codigo_4_ii = $query->row();

    //View tipos sector 4. Representacion
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('4_ii_representacion');
    $CI->db->join('tipos_sector', '4_ii_representacion.sector_productivo=tipos_sector.idtipo_sector');
    $CI->db->where($where);;
    $query = $CI->db->get();
    $view_tipos4 = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();

    //II- DECLARACIÓN DE INTERESES
    //II- 4. REPRESENTACIÓN /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    if ($codigo_4_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.4, 30.5, 4, 4);
    }

    //SIN CAMBIO--SOLO PARA FORMATO MOD
    if ($codigo_4_ii->ninguno == '2') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.5, 23.9, 4, 4);
    }
    //FORMATO INICIAL
    if ($codigo->tipo_formato == 1) {
        $pdf->SetY(23);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
    }
    //AGREGO POR LO MENOS 1
    if ($codigo_4_ii->ninguno == '0') {
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(30);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # 1'), 0, 0, true);
    }

    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Arial', 'B', 8);
    if ($codigo_4_ii->mexico_extranjero == 'EN EL EXTRANJERO') {
        $pdf->Text(90, 110, utf8_decode('PAÍS DONDE SE LOCALIZA'));
    } else {
        $pdf->Text(90, 110, utf8_decode('ENTIDAD FEDERATIVA'));
    }

    $pdf->SetFont('Arial', '', 8);
    $pdf->SetY(59.5);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->declarante));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(55, 4, utf8_decode($codigo_4_ii->tipo_representacion));
    $pdf->Cell(65, 4, utf8_decode($codigo_4_ii->fecha_inicio));
    $pdf->Cell(64, 4, utf8_decode($codigo_4_ii->representante));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(122, 4, utf8_decode($codigo_4_ii->nombre_representante));
    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->Cell(95, 4, utf8_decode($codigo_4_ii->rfc));
    $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->remuneracion));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->monto_mensual));
    $pdf->Ln(5.5);
    $pdf->SetX(105);
    $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->mexico_extranjero));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->entidad_pais));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    if ($codigo_4_ii->sector_productivo == '17') {
        $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->sector_productivo_esp));
    } else {
        // $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->sector_productivo));
        if ($view_tipos4 != null) {
            $pdf->Cell(92, 4, utf8_decode($view_tipos4->nombre));
        }
    }
    $pdf->SetY(132);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_4_ii->aclaraciones));

}

