<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla5ii($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('5_ii_clientes', $where, 1);
    $codigo_5_ii = $query->row();


    //View tipos sector 5. Clientes
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('5_ii_clientes');
    $CI->db->join('tipos_sector', '5_ii_clientes.sector_productivo=tipos_sector.idtipo_sector');
    $CI->db->where($where);;
    $query = $CI->db->get();
    $view_tipos5 = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();

    //II- DECLARACIÓN DE INTERESES
    //II- 5. CLIENTES PRINCIPALES
    if ($codigo_5_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.3, 26.8, 4, 4);
    }



    //SIN CAMBIO--SOLO PARA FORMATO MOD
    if ($codigo_5_ii->ninguno == '2') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.5, 19.5, 4, 4);
    }
    //FORMATO INICIAL
    if ($codigo->tipo_formato == 1) {
        $pdf->SetY(19);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
    }
    //AGREGO POR LO MENOS 1
    if ($codigo_5_ii->ninguno == '0') {
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(26);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # 1'), 0, 0, true);
    }


    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Arial', 'B', 8);
    if ($codigo_5_ii->mexico_extranjero == 'EN EL EXTRANJERO') {
        $pdf->Text(90, 142, utf8_decode('PAÍS DONDE SE LOCALIZA'));
    } else {
        $pdf->Text(90, 142, utf8_decode('ENTIDAD FEDERATIVA'));
    }

    $pdf->SetFont('Arial', '', 8);
    $pdf->SetY(66);
    $pdf->SetX(13);
    $pdf->Cell(15, 4, utf8_decode($codigo_5_ii->actividad));
    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->declarante));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(88, 4, utf8_decode($codigo_5_ii->nombre_empresa));
    $pdf->Ln(10.5);
    $pdf->SetX(13);
    $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->rfc_empresa));
    $pdf->Cell(80, 4, utf8_decode($codigo_5_ii->cliente_principal));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(122, 4, utf8_decode($codigo_5_ii->razon_social));
    $pdf->Ln(5);
    $pdf->SetX(108);
    $pdf->Cell(62, 4, utf8_decode($codigo_5_ii->rfc_razon));
    $pdf->Ln(10);
    $pdf->SetX(13);
    if ($codigo_5_ii->sector_productivo == '17') {
        $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->sector_productivo_esp));
    } else {
        // $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->sector_productivo));
        if ($view_tipos5 != null) {
            $pdf->Cell(95, 4, utf8_decode($view_tipos5->nombre));
        }
    }
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(20, 4, utf8_decode($codigo_5_ii->monto_mensual));
    $pdf->Ln(5);
    $pdf->SetX(105);
    $pdf->Cell(92, 4, utf8_decode($codigo_5_ii->mexico_extranjero));
    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_5_ii->entidad_pais));
    $pdf->SetY(154);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_5_ii->aclaraciones));

}

