<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla7ii($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('7_ii_fideicomisos', $where, 1);
    $codigo_7_ii = $query->row();

    //View tipos sector 7. Fideicomisos
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('7_ii_fideicomisos');
    $CI->db->join('tipos_sector', '7_ii_fideicomisos.sector_productivo=tipos_sector.idtipo_sector');
    $CI->db->where($where);
    $query = $CI->db->get();
    $view_tipos7 = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();

    //II- DECLARACIÓN DE INTERESES

    ///////////7. FIDEICOMISOS
    if ($codigo_7_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.4, 28.5, 4, 4);
    }


    //SIN CAMBIO--SOLO PARA FORMATO MOD
    if ($codigo_7_ii->ninguno == '2') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.5, 21, 4, 4);
    }
    //FORMATO INICIAL
    if ($codigo->tipo_formato == 1) {
        $pdf->SetY(20);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
    }
    //AGREGO POR LO MENOS 1
    if ($codigo_7_ii->ninguno == '0') {
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(27);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # 1'), 0, 0, true);
    }
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetY(66);
    $pdf->SetX(13);
    $pdf->Cell(61, 4, utf8_decode($codigo_7_ii->participacion));
    $pdf->Cell(62, 4, utf8_decode($codigo_7_ii->tipo_fideicomiso));
    $pdf->Cell(61, 4, utf8_decode($codigo_7_ii->tipo_participacion));
    $pdf->Ln(5);
    $pdf->SetX(108);
    $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->rfc_fideicomiso));
    $pdf->Ln(11);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->fideicomitente));
    $pdf->Ln(11.5);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->nombre_fideicomitente));
    $pdf->Ln(5.5);
    $pdf->SetX(108);
    $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->rfc_fideicomitente));
    $pdf->Ln(11);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->nombre_fiduciario));
    $pdf->Ln(5.5);
    $pdf->SetX(108);
    $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->rfc_fiduciario));
    $pdf->Ln(12);
    $pdf->SetX(13);
    $pdf->Cell(48, 4, utf8_decode($codigo_7_ii->fideicomisario));
    $pdf->Ln(11);
    $pdf->SetX(13);
    $pdf->Cell(75, 4, utf8_decode($codigo_7_ii->nombre_fideicomisario));
    $pdf->Ln(6);
    $pdf->SetX(108);
    $pdf->Cell(60, 4, utf8_decode($codigo_7_ii->rfc_fideicomisario));
    $pdf->Ln(11.5);
    $pdf->SetX(13);
    // $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->sector_productivo));
    if ($codigo_7_ii->sector_productivo == '17') {
        $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->sector_productivo_esp));
    } else {
        if ($view_tipos7 != null) {
            $pdf->Cell(92, 4, utf8_decode($view_tipos7->nombre));
        }
    }
    $pdf->Text(130, 163, utf8_decode($codigo_7_ii->mexico_extranjero));
    // $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->mexico_extranjero));
    $pdf->SetY(170);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_7_ii->aclaraciones));

}

