<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla_declaracion($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('1_ii_participacion_empresas', $where, 1);
    $codigo_1_ii = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('2_ii_toma_decisiones', $where, 1);
    $codigo_2_ii = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('3_ii_apoyos', $where, 1);
    $codigo_3_ii = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('4_ii_representacion', $where, 1);
    $codigo_4_ii = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('5_ii_clientes', $where, 1);
    $codigo_5_ii = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('6_ii_beneficios', $where, 1);
    $codigo_6_ii = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('7_ii_fideicomisos', $where, 1);
    $codigo_7_ii = $query->row();


    //II. Declaracion de intereses
    //View tipos sector 1. Participacion empresas
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('1_ii_participacion_empresas');
    $CI->db->join('tipos_sector', '1_ii_participacion_empresas.sector_productivo=tipos_sector.idtipo_sector');
    $CI->db->where($where);;
    $query = $CI->db->get();
    $view_tipos1 = $query->row();

    //View tipos sector 4. Representacion
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('4_ii_representacion');
    $CI->db->join('tipos_sector', '4_ii_representacion.sector_productivo=tipos_sector.idtipo_sector');
    $CI->db->where($where);;
    $query = $CI->db->get();
    $view_tipos4 = $query->row();

    //View tipos sector 5. Clientes
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('5_ii_clientes');
    $CI->db->join('tipos_sector', '5_ii_clientes.sector_productivo=tipos_sector.idtipo_sector');
    $CI->db->where($where);;
    $query = $CI->db->get();
    $view_tipos5 = $query->row();

    //View tipos sector 6. Beneficios
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('6_ii_beneficios');
    $CI->db->join('tipos_sector', '6_ii_beneficios.sector_productivo=tipos_sector.idtipo_sector');
    $CI->db->where($where);;
    $query = $CI->db->get();
    $view_tipos6 = $query->row();

    //View tipos sector 7. Fideicomisos
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('7_ii_fideicomisos');
    $CI->db->join('tipos_sector', '7_ii_fideicomisos.sector_productivo=tipos_sector.idtipo_sector');
    $CI->db->where($where);
    $query = $CI->db->get();
    $view_tipos7 = $query->row();



    $pdf->setSourceFile('plantillas/Declaracion_Intereses.pdf');
    $pdf->AddPage();
    $tplIdx = $pdf->importPage(1);
    $pdf->useTemplate($tplIdx, 0, 0);
    //II- DECLARACIÓN DE INTERESES
    //1. PARTICIPACIÓN EN EMPRESAS, SOCIEDADES O ASOCIACIONES
    if ($codigo_1_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.3, 32, 4, 4);
    }
    $pdf->SetY(51);
    $pdf->SetX(105);
    $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->declarante));
    $pdf->Ln(11);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->nombre_empresa));
    $pdf->Cell(40, 4, utf8_decode($codigo_1_ii->rfc));
    $pdf->Cell(52, 4, utf8_decode($codigo_1_ii->porcentaje));
    $pdf->Ln(11.5);
    $pdf->SetX(13);

    if ($codigo_1_ii->tipo_participacion == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->tipo_participacion_esp));
    } else {
        $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->tipo_participacion));
    }

    $pdf->Cell(43, 4, utf8_decode($codigo_1_ii->remuneracion));
    $pdf->Cell(49, 4, utf8_decode($codigo_1_ii->monto_mensual));
    $pdf->Ln(8);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->mexico_extranjero));
    $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->entidad_pais));
    $pdf->Ln(4);
    $pdf->SetX(105);

    if ($codigo_1_ii->sector_productivo == '17') {
        $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->sector_productivo_esp));
    } else {
        if ($view_tipos1) {
            $pdf->Cell(92, 4, utf8_decode($view_tipos1->nombre));
        }
    }
    $pdf->SetY(95);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_1_ii->aclaraciones));

    //II- 2. ¿PARTICIPA EN LA TOMA DE DECISIONES DE ALGUNA DE ESTAS INSTITUCIONES ?
    if (
        $codigo_2_ii->ninguno == '1'
    ) {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.3, 118.5, 4, 4);
    }
    $pdf->SetY(142.5);
    $pdf->SetX(105);
    $pdf->Cell(92, 4, utf8_decode($codigo_2_ii->declarante));
    $pdf->Ln(8);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_2_ii->nombre_institucion));
    $pdf->Cell(40, 4, utf8_decode($codigo_2_ii->rfc));
    $pdf->Cell(52, 4, utf8_decode($codigo_2_ii->puesto));
    $pdf->Ln(11.5);
    $pdf->SetX(13);
    if ($codigo_2_ii->tipo_institucion == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(85, 4, utf8_decode($codigo_2_ii->tipo_institucion_esp));
    } else {
        $pdf->Cell(85, 4, utf8_decode($codigo_2_ii->tipo_institucion));
    }

    $pdf->Cell(57, 4, utf8_decode($codigo_2_ii->fecha_inicio));
    $pdf->Cell(42, 4, utf8_decode($codigo_2_ii->monto_mensual));
    $pdf->Ln(4);
    $pdf->SetX(155);
    $pdf->Cell(42, 4, utf8_decode($codigo_2_ii->remuneracion));
    $pdf->Ln(8);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_2_ii->mexico_extranjero));
    $pdf->Cell(92, 4, utf8_decode($codigo_2_ii->entidad_pais));
    $pdf->SetY(183);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_2_ii->aclaraciones));

    //II- 3.APOYOS O BENEFICIOS PÚBLICOS
    if ($codigo_3_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.3, 206, 4, 4);
    }
    $pdf->SetY(219);
    $pdf->SetX(85);
    $pdf->Cell(92, 4, utf8_decode($codigo_3_ii->beneficiario));
    $pdf->Ln(7.5);
    $pdf->SetX(13);
    $pdf->Cell(73, 4, utf8_decode($codigo_3_ii->nombre_programa));
    $pdf->Cell(64, 4, utf8_decode($codigo_3_ii->institucion));
    $pdf->Cell(47, 4, utf8_decode($codigo_3_ii->nivel_gobierno));
    $pdf->Ln(11.5);
    $pdf->SetX(13);
    //$pdf->Cell(85, 4, utf8_decode($codigo_3_ii->tipo_apoyo));
    if ($codigo_3_ii->tipo_apoyo == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(85, 4, utf8_decode($codigo_3_ii->tipo_apoyo_esp));
    } else {
        $pdf->Cell(85, 4, utf8_decode($codigo_3_ii->tipo_apoyo));
    }
    $pdf->Cell(60, 4, utf8_decode($codigo_3_ii->forma_recepcion));
    $pdf->Cell(39, 4, utf8_decode($codigo_3_ii->monto_apoyo));
    $pdf->Ln(4.5);
    $pdf->SetX(53);
    $pdf->MultiCell(140, 3.5, utf8_decode($codigo_3_ii->especifique_apoyo));
    $pdf->SetY(251.5);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_3_ii->aclaraciones));

    $pdf->SetFont('Arial', 'B', 8);
    if ($codigo_1_ii->mexico_extranjero == 'EN EL EXTRANJERO') {
        $pdf->Text(130, 80, utf8_decode('PAÍS DONDE SE LOCALIZA'));
    } else {
        $pdf->Text(130, 80, utf8_decode('ENTIDAD FEDERATIVA'));
    }

    if ($codigo_2_ii->mexico_extranjero == 'EN EL EXTRANJERO') {
        $pdf->Text(130, 173, utf8_decode('PAÍS DONDE SE LOCALIZA'));
    } else {
        $pdf->Text(130, 173, utf8_decode('ENTIDAD FEDERATIVA'));
    }


    $pdf->AddPage();
    $tplIdx = $pdf->importPage(2);
    $pdf->useTemplate($tplIdx, 0, 0);
    //II- 4. REPRESENTACIÓN /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    if ($codigo_4_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.3, 14.8, 4, 4);
    }
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetY(34.5);
    $pdf->SetX(105);
    $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->declarante));
    $pdf->Ln(8);
    $pdf->SetX(13);
    $pdf->Cell(55, 4, utf8_decode($codigo_4_ii->tipo_representacion));
    $pdf->Cell(65, 4, utf8_decode($codigo_4_ii->fecha_inicio));
    $pdf->Cell(64, 4, utf8_decode($codigo_4_ii->representante));
    $pdf->Ln(8);
    $pdf->SetX(13);
    $pdf->Cell(122, 4, utf8_decode($codigo_4_ii->nombre_representante));
    $pdf->Cell(62, 4, utf8_decode($codigo_4_ii->rfc));
    $pdf->Ln(8.5);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->remuneracion));
    $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->monto_mensual));
    $pdf->Ln(8);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->mexico_extranjero));
    $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->entidad_pais));
    $pdf->Ln(4);
    $pdf->SetX(105);
    if ($codigo_4_ii->sector_productivo == '17') {
        $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->sector_productivo_esp));
    } else {
        // $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->sector_productivo));
        if ($view_tipos4 != null) {
            $pdf->Cell(92, 4, utf8_decode($view_tipos4->nombre));
        }
    }
    $pdf->SetY(80.5);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_4_ii->aclaraciones));

    //II- 5. CLIENTES PRINCIPALES
    if ($codigo_5_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.3, 100.6, 4, 4);
    }
    $pdf->SetY(120);
    $pdf->SetX(180);
    $pdf->Cell(15, 4, utf8_decode($codigo_5_ii->actividad));
    $pdf->Ln(4);
    $pdf->SetX(100);
    $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->declarante));
    $pdf->Ln(8);
    $pdf->SetX(13);
    $pdf->Cell(88, 4, utf8_decode($codigo_5_ii->nombre_empresa));
    $pdf->Cell(52, 4, utf8_decode($codigo_5_ii->rfc_empresa));
    $pdf->Cell(44, 4, utf8_decode($codigo_5_ii->cliente_principal));
    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->Cell(122, 4, utf8_decode($codigo_5_ii->razon_social));
    $pdf->Cell(62, 4, utf8_decode($codigo_5_ii->rfc_razon));
    $pdf->Ln(4);
    $pdf->SetX(100);
    if ($codigo_5_ii->sector_productivo == '17') {
        $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->sector_productivo_esp));
    } else {
        // $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->sector_productivo));
        if ($view_tipos5 != null) {
            $pdf->Cell(95, 4, utf8_decode($view_tipos5->nombre));
        }
    }
    $pdf->Ln(4);
    $pdf->SetX(163);
    $pdf->Cell(20, 4, utf8_decode($codigo_5_ii->monto_mensual));
    $pdf->Ln(8);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_5_ii->mexico_extranjero));
    $pdf->Cell(92, 4, utf8_decode($codigo_5_ii->entidad_pais));
    $pdf->SetY(166.5);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_5_ii->aclaraciones));

    /////////// II- 6. BENEFICIOS PRIVADOS
    if ($codigo_6_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.3, 186.2, 4, 4);
    }
    $pdf->SetY(203);
    $pdf->SetX(13);
    if ($codigo_6_ii->tipo_beneficio == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(92, 4, utf8_decode($codigo_6_ii->tipo_beneficio_esp));
    } else {
        $pdf->Cell(92, 4, utf8_decode($codigo_6_ii->tipo_beneficio));
    }
    $pdf->Cell(92, 4, utf8_decode($codigo_6_ii->beneficiario));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(50, 4, utf8_decode($codigo_6_ii->otorgante));
    $pdf->Cell(80, 4, utf8_decode($codigo_6_ii->nombre_otorgante));
    $pdf->Cell(54, 4, utf8_decode($codigo_6_ii->rfc));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(60, 4, utf8_decode($codigo_6_ii->forma_recepcion));
    $pdf->Cell(124, 4, utf8_decode($codigo_6_ii->beneficio));
    $pdf->Ln(8);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_6_ii->monto_mensual));
    $pdf->Cell(92, 4, utf8_decode($codigo_6_ii->tipo_moneda));
    $pdf->Ln(4.5);
    $pdf->SetX(78);
    if ($codigo_6_ii->sector_productivo == '17') {
        $pdf->Cell(110, 4, utf8_decode($codigo_6_ii->sector_productivo_esp));
    } else {
        if ($view_tipos6 != null) {
            $pdf->Cell(110, 4, utf8_decode($view_tipos6->nombre));
        }
    }
    $pdf->SetY(244.5);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_6_ii->aclaraciones));


    $pdf->SetFont('Arial', 'B', 8);
    if ($codigo_4_ii->mexico_extranjero == 'EN EL EXTRANJERO') {
        $pdf->Text(130, 66, utf8_decode('PAÍS DONDE SE LOCALIZA'));
    } else {
        $pdf->Text(130, 66, utf8_decode('ENTIDAD FEDERATIVA'));
    }
    if ($codigo_5_ii->mexico_extranjero == 'EN EL EXTRANJERO') {
        $pdf->Text(130, 156, utf8_decode('PAÍS DONDE SE LOCALIZA'));
    } else {
        $pdf->Text(130, 156, utf8_decode('ENTIDAD FEDERATIVA'));
    }
    //break

    //case 10:
    //II- 7. FIDEICOMISOS
    // $pdf->AddPage();
    // $tplIdx = $pdf->importPage(11);
    // $pdf->useTemplate($tplIdx, 0, 0);
    $pdf->AddPage();
    $tplIdx = $pdf->importPage(3);
    $pdf->useTemplate($tplIdx, 0, 0);
    if ($codigo_7_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.4, 19.6, 4, 4);
    }
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetY(43);
    $pdf->SetX(13);
    $pdf->Cell(61, 4, utf8_decode($codigo_7_ii->participacion));
    $pdf->Cell(62, 4, utf8_decode($codigo_7_ii->tipo_fideicomiso));
    $pdf->Cell(61, 4, utf8_decode($codigo_7_ii->tipo_participacion));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->rfc_fideicomiso));
    $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->fideicomitente));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->nombre_fideicomitente));
    $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->rfc_fideicomitente));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->nombre_fiduciario));
    $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->rfc_fiduciario));
    $pdf->Ln(12);
    $pdf->SetX(13);
    $pdf->Cell(48, 4, utf8_decode($codigo_7_ii->fideicomisario));
    $pdf->Cell(75, 4, utf8_decode($codigo_7_ii->nombre_fideicomisario));
    $pdf->Cell(60, 4, utf8_decode($codigo_7_ii->rfc_fideicomisario));
    $pdf->Ln(8);
    $pdf->SetX(13);
    // $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->sector_productivo));
    if ($codigo_7_ii->sector_productivo == '17') {
        $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->sector_productivo_esp));
    } else {
        if ($view_tipos7 != null) {
            $pdf->Cell(92, 4, utf8_decode($view_tipos7->nombre));
        }
    }
    $pdf->Text(130, 96, utf8_decode($codigo_7_ii->mexico_extranjero));
    // $pdf->Cell(92, 4, utf8_decode($codigo_7_ii->mexico_extranjero));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_7_ii->aclaraciones));

}

