<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla5test($idformato, $pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('5_experiencia_laboral', $where, 1);
    $codigo_5 = $query->row();


    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();

    //View tipos sector 6. Datos de la pareja
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('5_experiencia_laboral');
    $CI->db->join('tipos_sector', '5_experiencia_laboral.sector=tipos_sector.idtipo_sector');
    $CI->db->where($where);;
    $query = $CI->db->get();
    $view_tipos5_I = $query->row();

    // 5
    $pdf->setSourceFile('plantillas/Experiencia_5.pdf');
    $pdf->AddPage();
    $tplIdx = $pdf->importPage(1);
    $pdf->useTemplate($tplIdx, 0, 0);


    if ($codigo_5->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.2, 25.1, 4, 4);
    }
    if ($codigo->tipo_formato == 1) {
        $pdf->SetFont('Arial', 'B', 10);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(17);
        $pdf->SetX(175);
        $pdf->MultiCell(27, 7, utf8_decode('  '), 0, 0, true);
        $pdf->SetTextColor(0, 0, 0);
    } else {
        if ($codigo_5->ninguno == '2') {
            $logo = SERVIDOR . APP . 'application/images/check2.png';
            $pdf->Image($logo, 197.2, 18, 4, 4);
        }
    }

    if ($codigo_5->ninguno != '1') {
    $pdf->SetFillColor(0, 0, 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetY(49);
    $pdf->SetX(13);
    if ($codigo_5->ambito_sector == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(65, 4, utf8_decode($codigo_5->ambito_sector_esp));
    } else {
        $pdf->Cell(65, 4, utf8_decode($codigo_5->ambito_sector));
    }
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(96, 4, utf8_decode($codigo_5->nivel_orden));
    $pdf->Cell(92, 4, utf8_decode($codigo_5->ambito));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(152, 4, utf8_decode($codigo_5->ente_publico));

        $rfc = $codigo_5->rfc;
        //Tomamos las primeras 4 letras de la cadena
        $rfc=   substr($codigo_5->rfc, 0, -8);
        // $pdf->Cell(35, 4, utf8_decode('RFC::::::'.$rfc));
        if (ctype_alpha($rfc)) {
       // Inicia con 4 letras
            $pdf->Cell(38, 4, utf8_decode($codigo_5->rfc), 0, 0, '', true);
        }else{
          //  Inicia con solo 3 letras
            $pdf->Cell(35, 4, utf8_decode($codigo_5->rfc));
        }

    

   // $pdf->Cell(35, 4, utf8_decode($codigo_5->rfc));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(95, 4, utf8_decode($codigo_5->area_adscripcion));
    $pdf->Cell(63, 4, utf8_decode($codigo_5->empleo));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(59, 4, utf8_decode($codigo_5->funcion_principal));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    if ($codigo_5->sector == '17') {
        $pdf->Cell(62, 4, utf8_decode($codigo_5->sector_esp));
    } else {
        if ($view_tipos5_I != null) {
            $pdf->Cell(62, 4, utf8_decode($view_tipos5_I->nombre));
            //$pdf->Cell(62, 4, utf8_decode($codigo_5->sector));
        }
    }
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(63, 4, utf8_decode($codigo_5->fecha_ingreso));
    $pdf->Cell(64, 4, utf8_decode($codigo_5->fecha_egreso));
    $pdf->Cell(62, 4, utf8_decode($codigo_5->lugar));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->MultiCell(190, 3.5, utf8_decode($codigo_5->aclaraciones), 0, '', true);

    }
}
