<?php
class Cargos_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('cargos_model');
    }

    // Función para obtener la lista de tipos de usuarios


    // Función para obtener el tipo de usuario basado en el ID
    public function obtenerTipoDeCargo($idCargo)
    {
        $this->db
        ->select('tipo')
        ->from('cargos')
        ->where('idcargo = ', $idCargo);
        
        $tipoDeCargo =  $this->db->get()->row_array()["tipo"];

        $respuesta = array(
            'respuesta' => $tipoDeCargo,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    // Función para obtener la lista de usuarios activos
    public function obtenerCargos()
    {
        $this->db
        ->select('*')
        ->from('empleados')
        ->where('clave >= ', 1);

        $cargos = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $cargos,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

 
    public function obtenerCargo()
    {
        $id = $this->uri->segment(3);
        $where =  array('id' => $id);
        $query = $this->db->select("*")->get_where('empleados', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                    'mensaje' => 'Registros cargado correctamente',
                    'registro' => $data,
                    'status' => 200,
                );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'status' => 400,
            );
        }
        return $respuesta;
    }


  



    public function agregarCargo($datos)
    {
        $id = $datos['id'];
        $data = array(
            'clave' => $datos['clave'],
            'nombre' => $datos['nombre'],
            'rfc' => $datos['rfc'],
            'curp' => $datos['curp'],
            'secretaria' => $datos['secretaria'],
            'puesto' => $datos['puesto'],
            'departamento' => $datos['departamento'],
            'nivel' => $datos['nivel'],
            'fechaingreso' => $datos['fechaingreso'],
            
        );
        if ($id > 0) {
            $this->db->where('id', $id);
            $this->db->update('empleados', $data);
            $id = $id;
        } else {
            $this->db->insert('empleados', $data);
            $id = $this->db->insert_id();
        }

        if (
            $this->db->trans_status() === false
        ) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    // public function cambiarEstado($idCargo)
    // {
    //     $this->db->trans_begin();
        
    //     $this->db
    //     ->set('activo', 'NOT activo', FALSE)
    //     ->where('idcargo', $idCargo)
    //     ->update('cargos');

    //     if($this->db->trans_status() === FALSE)
    //     {
    //         $this->db->trans_rollback();

    //         $respuesta = "Ocurrio un error, vuelva a intentar.";
    //         $status = REST_Controller::HTTP_INTERNAL_SERVER_ERROR;
    //     }

    //     else
    //     {
    //         $this->db->trans_commit();   

    //         $respuesta = "Estado actualizado correctamente";
    //         $status = REST_Controller::HTTP_OK;
    //     }    

    //     return array(
    //         'respuesta' =>  $respuesta,
    //         'status' => $status
    //     );
    // }

    public function paginado($datos)
    {
        $this->load->library('paginado');
        $paginado = $this->paginado->paginar($datos, 'empleados');
        
        $respuesta = array(
            'respuesta' => $paginado,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }


    public function eliminarCargo($data)
    {
        $id = $data['0'];
        $this->db->trans_begin();
        $where =  array('id' => $id);
        $query = $this->db->select("*")->get_where('empleados', $where);

        if ($query && $query->num_rows() >= 1) {
            $this->db->delete('empleados', array('id' => $id));
            if ($this->db->trans_status() === false) {
                $this->db->trans_rollback();
                $respuesta = array(
                    'mensaje' => 'Error en eliminación.',
                    'error' => $this->db->error(),
                    'status' => 409,
                );
            } else {
                $this->db->trans_commit();
                $respuesta = array(
                    'mensaje' => 'Eliminación correcta',
                    'status' => 200,
                );
            }
            return $respuesta;
        } else {
            $respuesta = array(
                'mensaje' => 'No existe el id',
                'status' => 400,
            );
            return $respuesta;
        }
    }
}
 