<?php

class Datos12_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

//  I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL INICIAL
//DATOS-12. 

    public function agregar12($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(

            'tipo_inversion' => $datos['tipo_inversion'],
            'titular_inversion' => $datos['titular_inversion'],
            'bancaria' => $datos['bancaria'],
            'tercero' => $datos['tercero'],
            'nombre_tercero' => $datos['nombre_tercero'],
            'rfc_tercero' => $datos['rfc_tercero'],
            'fondos_inversion' => $datos['fondos_inversion'],
            'organizaciones_privadas' => $datos['organizaciones_privadas'],
            'posesion_monedas' => $datos['posesion_monedas'],
            'seguros' => $datos['seguros'],
            'valores_bursatiles' => $datos['valores_bursatiles'],
            'afores_otros' => $datos['afores_otros'],
            'numero_cuenta' => $datos['numero_cuenta'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'institucion' => $datos['institucion'],
            'rfc_pais' => $datos['rfc_pais'],
            'saldo' => $datos['saldo'],
            'tipo_moneda' => $datos['tipo_moneda'],
            'ninguno' => $datos['ninguno'], 
            'aclaraciones' => $datos['aclaraciones'],

            'progreso' => 5,
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('12_inversiones', $data);
            $id = $idformato;
        } else {
            $this->db->insert('12_inversiones', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener12()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('12_inversiones', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtenerTiposDeclarante()
    {
        $this->db->select('*')->from('tipos_declarante');
        $publicidad = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $publicidad,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }


    public function obtener_add($idformato, $idinversion)
    {
        $where =  array(
            'idformato' => $idformato,
            'idinversion' => $idinversion
        );

        $query = $this->db->select("*")->get_where('12_inversiones_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener12_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('12_inversiones_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar12_add($datos)
    {
        $idformato = $datos['idformato'];
        $idinversion = $datos['idinversion'];
        $data = array(
            'idformato' => $datos['idformato'],
            'tipo_inversion' => $datos['tipo_inversion'],
            'titular_inversion' => $datos['titular_inversion'],
            'bancaria' => $datos['bancaria'],
            'tercero' => $datos['tercero'],
            'nombre_tercero' => $datos['nombre_tercero'],
            'rfc_tercero' => $datos['rfc_tercero'],
            'fondos_inversion' => $datos['fondos_inversion'],
            'organizaciones_privadas' => $datos['organizaciones_privadas'],
            'posesion_monedas' => $datos['posesion_monedas'],
            'seguros' => $datos['seguros'],
            'valores_bursatiles' => $datos['valores_bursatiles'],
            'afores_otros' => $datos['afores_otros'],
            'numero_cuenta' => $datos['numero_cuenta'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'institucion' => $datos['institucion'],
            'rfc_pais' => $datos['rfc_pais'],
            'saldo' => $datos['saldo'],
            'tipo_moneda' => $datos['tipo_moneda'],
            'ninguno' => $datos['ninguno'],
            'aclaraciones' => $datos['aclaraciones'],
            'activo' =>  1,

        );
        if ($idinversion > 0) {
            $this->db->where('idinversion', $idinversion);
            $this->db->update('12_inversiones_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('12_inversiones_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaInversion($datos)
    {
        $idinversion = $datos['idinversion'];

        $data = array(
            'activo' => 0,
        );
        if ($idinversion > 0) {

            $this->db->where('idinversion', $idinversion);
            $this->db->update('12_inversiones_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

  
}
