<?php

class Datos14_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

//  I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL INICIAL
//DATOS-14. 

    public function agregar14($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(
            'inmueble' => $datos['inmueble'],
            'tipo_bien' => $datos['tipo_bien'],
            'tipo_bien_esp' => $datos['tipo_bien_esp'],
            //Domicilio
            'calle' =>  $datos['calle'],
            'numero_ext' =>  $datos['numero_ext'],
            'numero_int' =>  $datos['numero_int'],
            'localidad' =>  $datos['localidad'],
            'codigo_postal' =>  $datos['codigo_postal'],
            'municipio_estado' =>  $datos['municipio_estado'],
            'entidad_pais' =>  $datos['entidad_pais'],
            'mexico_extranjero' =>  $datos['mexico_extranjero'],

            'vehiculo' => $datos['vehiculo'],
            'tipo_vehiculo' => $datos['tipo_vehiculo'],
            'tipo_vehiculo_esp' => $datos['tipo_vehiculo_esp'],
            'marca' => $datos['marca'],
            'modelo' => $datos['modelo'],
            'anio' => $datos['anio'],
            'numero_serie' => $datos['numero_serie'],
            // 'lugar_registro' => $datos['lugar_registro'],
            'mexico_extranjero2' => $datos['mexico_extranjero2'],
            'entidad_pais_registro' => $datos['entidad_pais_registro'],
            'titular' => $datos['titular'],
            'nombre_titular' => $datos['nombre_titular'],
            'rfc_titular' => $datos['rfc_titular'],
            'relacion_titular' => $datos['relacion_titular'],
            
            'ninguno' => $datos['ninguno'], 
            'aclaraciones' => $datos['aclaraciones'],

            'progreso' => 5,
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('14_prestamos', $data);
            $id = $idformato;
        } else {
            $this->db->insert('14_prestamos', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener14()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('14_prestamos', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }


    public function obtener_add($idformato, $idprestamo)
    {
        $where =  array(
            'idformato' => $idformato,
            'idprestamo' => $idprestamo
        );

        $query = $this->db->select("*")->get_where('14_prestamos_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener14_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('14_prestamos_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar14_add($datos)
    {
        $idformato = $datos['idformato'];
        $idprestamo = $datos['idprestamo'];
        $data = array(
            'idformato' => $datos['idformato'],
            'inmueble' => $datos['inmueble'],
            'tipo_bien' => $datos['tipo_bien'],
            'tipo_bien_esp' => $datos['tipo_bien_esp'],
            'calle' =>  $datos['calle'],
            'numero_ext' =>  $datos['numero_ext'],
            'numero_int' =>  $datos['numero_int'],
            'localidad' =>  $datos['localidad'],
            'codigo_postal' =>  $datos['codigo_postal'],
            'municipio_estado' =>  $datos['municipio_estado'],
            'entidad_pais' =>  $datos['entidad_pais'],
            'mexico_extranjero' =>  $datos['mexico_extranjero'],
            'vehiculo' => $datos['vehiculo'],
            'tipo_vehiculo' => $datos['tipo_vehiculo'],
            'tipo_vehiculo_esp' => $datos['tipo_vehiculo_esp'],
            'marca' => $datos['marca'],
            'modelo' => $datos['modelo'],
            'anio' => $datos['anio'],
            'numero_serie' => $datos['numero_serie'],
            'mexico_extranjero2' => $datos['mexico_extranjero2'],
            'entidad_pais_registro' => $datos['entidad_pais_registro'],
            'titular' => $datos['titular'],
            'nombre_titular' => $datos['nombre_titular'],
            'rfc_titular' => $datos['rfc_titular'],
            'relacion_titular' => $datos['relacion_titular'],
            'aclaraciones' => $datos['aclaraciones'],
            'activo' =>  1,

        );
        if ($idprestamo > 0) {
            $this->db->where('idprestamo', $idprestamo);
            $this->db->update('14_prestamos_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('14_prestamos_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaPrestamo($datos)
    {
        $idprestamo = $datos['idprestamo'];

        $data = array(
            'activo' => 0,
        );
        if ($idprestamo > 0) {

            $this->db->where('idprestamo', $idprestamo);
            $this->db->update('14_prestamos_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

  
}
