<?php

class Datos3_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

//  I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL INICIAL
//DATOS-3. DATOS CURRICULARES DEL DECLARANTE

    public function agregar3($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(
            'nivel' =>  $datos['nivel'],
            'institucion_educativa' => $datos['institucion_educativa'],
            'carrera' => $datos['carrera'],
            'estatus' => $datos['estatus'],
            'documento' => $datos['documento'],
            'fecha_documento' => $datos['fecha_documento'],
            'lugar' => $datos['lugar'],
            'cambio' => $datos['cambio'],
            'aclaraciones_curriculares' => $datos['aclaraciones_curriculares'],
            'progreso' => 5,
        );
        // $porcentaje = array(
        //     'porcentaje' => 15,
        // );
        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('3_datos_curriculares', $data);

            // if ($datos['progreso'] < 20) {
            // $this->db->where('idformato', $idformato);
            // $this->db->update('progreso', $porcentaje);
            // }
            $id = $idformato;
        } else {
            $this->db->insert('3_datos_curriculares', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener3()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('3_datos_curriculares', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }


    //  II.- DECLARACIÓN DE INTERESES
    //DATOS-3. APOYOS O BENEFICIOS PÚBLICOS
    public function agregar3_ii($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(

            'beneficiario' => $datos['beneficiario'],
            'nombre_programa' => $datos['nombre_programa'],
            'institucion' => $datos['institucion'],
            'nivel_gobierno' => $datos['nivel_gobierno'],
            'tipo_apoyo' => $datos['tipo_apoyo'],
            'tipo_apoyo_esp' => $datos['tipo_apoyo_esp'],
            'forma_recepcion' => $datos['forma_recepcion'],
            'monto_apoyo' => $datos['monto_apoyo'],
            'especifique_apoyo' => $datos['especifique_apoyo'],

            'ninguno' => $datos['ninguno'],
            'aclaraciones' => $datos['aclaraciones'],

            'progreso' => 5,
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('3_ii_apoyos', $data);
            $id = $idformato;
        } else {
            $this->db->insert('3_ii_apoyos', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener3_ii()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('3_ii_apoyos', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }



    //Adicionales

    public function obtener_add($idformato, $idapoyo)
    {
        $where =  array(
            'idformato' => $idformato,
            'idapoyo' => $idapoyo
        );

        $query = $this->db->select("*")->get_where('3_ii_apoyos_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener3_ii_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('3_ii_apoyos_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar3_ii_add($datos)
    {
        $idformato = $datos['idformato'];
        $idapoyo = $datos['idapoyo'];
        $data = array(
            'idformato' => $datos['idformato'],
            'beneficiario' => $datos['beneficiario'],
            'nombre_programa' => $datos['nombre_programa'],
            'institucion' => $datos['institucion'],
            'nivel_gobierno' => $datos['nivel_gobierno'],
            'tipo_apoyo' => $datos['tipo_apoyo'],
            'tipo_apoyo_esp' => $datos['tipo_apoyo_esp'],
            'forma_recepcion' => $datos['forma_recepcion'],
            'monto_apoyo' => $datos['monto_apoyo'],
            'especifique_apoyo' => $datos['especifique_apoyo'],
            'aclaraciones' => $datos['aclaraciones'],

            'activo' =>  1,

        );
        if ($idapoyo > 0) {
            $this->db->where('idapoyo', $idapoyo);
            $this->db->update('3_ii_apoyos_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('3_ii_apoyos_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaPrestamo($datos)
    {
        $idapoyo = $datos['idapoyo'];

        $data = array(
            'activo' => 0,
        );
        if ($idapoyo > 0) {

            $this->db->where('idapoyo', $idapoyo);
            $this->db->update('3_ii_apoyos_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }



}
