<?php

class Datos4_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }


    public function agregar4($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(
            'nivel_orden' =>  $datos['nivel_orden'],
            'ambito' => $datos['ambito'],
            'ente_publico' => $datos['ente_publico'],
            'area' => $datos['area'],
            'empleo' => $datos['empleo'],
            'honorarios' => $datos['honorarios'],
            'nivel_empleo' => $datos['nivel_empleo'],
            'funcion' => $datos['funcion'],
            'fecha_posesion' => $datos['fecha_posesion'],
            'telefono_oficina' => $datos['telefono_oficina'],
            'aclaraciones' => $datos['aclaraciones'],

            //Domicilio
            'calle' => $datos['calle'],
            'numero_ext' => $datos['numero_ext'],
            'numero_int' => $datos['numero_int'],
            'localidad' => $datos['localidad'],
            'codigo_postal' => $datos['codigo_postal'],
            'aclaraciones_domicilio' => $datos['aclaraciones_domicilio'],
            'municipio_estado' => $datos['municipio_estado'],
            'entidad_pais' => $datos['entidad_pais'],
            'mexico_extranjero' => $datos['mexico_extranjero'],


            //SERVIDOR PUBLICO
            'servidor_publico' =>  $datos['servidor_publico'],
            'servidor_publico2' =>  $datos['servidor_publico2'],
            'nivel_orden_sp' =>  $datos['nivel_orden_sp'],
            'ambito_sp' => $datos['ambito_sp'],
            'ente_publico_sp' => $datos['ente_publico_sp'],
            'area_sp' => $datos['area_sp'],
            'empleo_sp' => $datos['empleo_sp'],
            'honorarios_sp' => $datos['honorarios_sp'],
            'nivel_empleo_sp' => $datos['nivel_empleo_sp'],
            'funcion_sp' => $datos['funcion_sp'],
            'fecha_posesion_sp' => $datos['fecha_posesion_sp'],
            'telefono_oficina_sp' => $datos['telefono_oficina_sp'],
            'aclaraciones_sp' => $datos['aclaraciones_sp'],

            //Domicilio
            'calle_sp' => $datos['calle_sp'],
            'numero_ext_sp' => $datos['numero_ext_sp'],
            'numero_int_sp' => $datos['numero_int_sp'],
            'localidad_sp' => $datos['localidad_sp'],
            'codigo_postal_sp' => $datos['codigo_postal_sp'],
            'aclaraciones_domicilio_sp' => $datos['aclaraciones_domicilio_sp'],
            'municipio_estado_sp' => $datos['municipio_estado_sp'],
            'entidad_pais_sp' => $datos['entidad_pais_sp'],
            'mexico_extranjero_sp' => $datos['mexico_extranjero_sp'],
            'progreso' => 5,
 

            //Formato Inicial
            'fecha_inicio' => $datos['fecha_inicio'],
            'fecha_conclusion' => $datos['fecha_conclusion'],
            'ingresos_netos' => $datos['ingresos_netos'],
            'remuneracion' => $datos['remuneracion'],
            'otros_ingresos' => $datos['otros_ingresos'],
            'actividad_industrial' => $datos['actividad_industrial'],
            'nombre_razonsocial' => $datos['nombre_razonsocial'],
            'tipo_negocio' => $datos['tipo_negocio'],
            'actividad_financiera' => $datos['actividad_financiera'],
            'tipo_instrumento' => $datos['tipo_instrumento'],
            'servicios_profesionales' => $datos['servicios_profesionales'],
            'tipo_servicio' => $datos['tipo_servicio'],
            'enajenacion_bienes' => $datos['enajenacion_bienes'],
            'tipo_bien' => $datos['tipo_bien'],
            'ingresos_noconsiderados' => $datos['ingresos_noconsiderados'],
            'tipo_ingreso' => $datos['tipo_ingreso'],
            'ingreso_neto' => $datos['ingreso_neto'],
            'ingreso_pareja' => $datos['ingreso_pareja'],
            'total_ingresos' => $datos['total_ingresos'],
            'aclaraciones_2' => $datos['aclaraciones_2'],
            'tipo_instrumento_esp' => $datos['tipo_instrumento_esp'],
            'cambio' => $datos['cambio'],



        );
        // $porcentaje = array(
        //     'porcentaje' => 20,
        // );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('4_datos_empleo', $data);
            $id = $idformato;

            // if ($datos['progreso'] < 25) {
            //     $this->db->where('idformato', $idformato);
            //     $this->db->update('progreso', $porcentaje);
            // }
        } else {
            $this->db->insert('4_datos_empleo', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener4()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('4_datos_empleo', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    //DATOS. II  -- DECLARACION DE INTERESES
    public function agregar4_ii($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(

            'declarante' => $datos['declarante'],
            'tipo_representacion' => $datos['tipo_representacion'],
            'fecha_inicio' => $datos['fecha_inicio'],
            'representante' => $datos['representante'],
            'nombre_representante' => $datos['nombre_representante'],
            'rfc' => $datos['rfc'],
            'remuneracion' => $datos['remuneracion'],
            'monto_mensual' => $datos['monto_mensual'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'entidad_pais' => $datos['entidad_pais'],
            'sector_productivo' => $datos['sector_productivo'],
            'sector_productivo_esp' => $datos['sector_productivo_esp'],

            'ninguno' => $datos['ninguno'],
            'aclaraciones' => $datos['aclaraciones'],

            'progreso' => 5,
        );
        
        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('4_ii_representacion', $data);
            $id = $idformato;
        } else {
            $this->db->insert('4_ii_representacion', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener4_ii()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('4_ii_representacion', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtenerTiposSector()
    {
        $this->db->select('*')->from('tipos_sector');
        $sector = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $sector,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function obtenerTiposSecretarias()
    {
        $this->db->select('*')->from('secretarias');
        $sector = $this->db->get()->result_array();
        $respuesta = array(
            'respuesta' => $sector,
            'status' => REST_Controller::HTTP_OK
        );
        return $respuesta;
    }

    public function obtenerTiposDirecciones()
    {
        $this->db->select('*')->from('direcciones');
        $sector = $this->db->get()->result_array();
        $respuesta = array(
            'respuesta' => $sector,
            'status' => REST_Controller::HTTP_OK
        );
        return $respuesta;
    }

    public function obtenerTiposEmpleos()
    {
        $this->db->select('*')->from('cargos');
        $sector = $this->db->get()->result_array();
        $respuesta = array(
            'respuesta' => $sector,
            'status' => REST_Controller::HTTP_OK
        );
        return $respuesta;
    }



    //Adicionales

    public function obtener_add($idformato, $idrepresentacion)
    {
        $where =  array(
            'idformato' => $idformato,
            'idrepresentacion' => $idrepresentacion
        );

        $query = $this->db->select("*")->get_where('4_ii_representacion_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener4_ii_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('4_ii_representacion_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar4_ii_add($datos)
    {
        $idformato = $datos['idformato'];
        $idrepresentacion = $datos['idrepresentacion'];
        $data = array(
            'idformato' => $datos['idformato'],
            'declarante' => $datos['declarante'],
            'tipo_representacion' => $datos['tipo_representacion'],
            'fecha_inicio' => $datos['fecha_inicio'],
            'representante' => $datos['representante'],
            'nombre_representante' => $datos['nombre_representante'],
            'rfc' => $datos['rfc'],
            'remuneracion' => $datos['remuneracion'],
            'monto_mensual' => $datos['monto_mensual'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'entidad_pais' => $datos['entidad_pais'],
            'sector_productivo' => $datos['sector_productivo'],
            'sector_productivo_esp' => $datos['sector_productivo_esp'],
            'aclaraciones' => $datos['aclaraciones'],

            'activo' =>  1,

        );
        if ($idrepresentacion > 0) {
            $this->db->where('idrepresentacion', $idrepresentacion);
            $this->db->update('4_ii_representacion_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('4_ii_representacion_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaRepresentacion($datos)
    {
        $idrepresentacion = $datos['idrepresentacion'];

        $data = array(
            'activo' => 0,
        );
        if ($idrepresentacion > 0) {

            $this->db->where('idrepresentacion', $idrepresentacion);
            $this->db->update('4_ii_representacion_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }
  
}
