<?php
class Declaracion_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('documentos_model');
    }

    public function agregarRegistro($datos)
    {
        $idformato = $datos['idformato'];
        $periodo = $datos['periodo'];

            if (count($_FILES) > 0) {
                if (!is_dir('./assets/documentos/' . $idformato . '/')) {
                    mkdir('./assets/documentos/' . $idformato . '/', 0777, true);
                }

                $config['upload_path'] = './assets/documentos/' . $idformato . '/';
                $config['encrypt_name'] = true;
                $config['allowed_types'] = 'png|jpg|jpeg|pdf';
                $config['max_size'] = '2000 KB';

                foreach ($_FILES as $name => $doc) {

                    $this->load->library("upload", $config);
                    if ($this->upload->do_upload($name)) {
                        $data = array("upload_data" => $this->upload->data());
                        $ruta = "documentos/" . $idformato . '/' . $this->upload->data('file_name');
                        $data_documento = array(
                            'idformato' => $idformato,
                            //'idestado' => 1,
                            'periodo' => $periodo,
                            'ruta' => $ruta,
                        );
                        $this->db->insert('documentos', $data_documento);
                    }
                }
            }
        if (
            $this->db->trans_status() === false
        ) {
            $this->db->trans_rollback();
            $respuesta = array(
                $this->db->last_query(),
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                $this->db->last_query(), 
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    

    public function obtenerDoc($idformato)
    {
//------------$whereDocumentos =  array('idformato' => $idformato);
        // $whereDocumentos = array('idformato == ' . $idformato );
        // $docs = $this->db->get_where('documentos', $whereDocumentos)->result();
        // foreach ($docs as $doc) {
        //     $doc->ruta = RUTA_IMG . $doc->ruta;
        //     $doc->guardado = 1;
        //     $pdf = substr($doc->ruta, -3);
        //     if ($pdf == 'pdf') {
        //         $doc->type = 'application/pdf';
        //     } else {
        //         $doc->type = substr($doc->ruta, -3);
        //     }
        // }
        // if ($this->db->trans_status() === false) {

        //     $this->db->trans_rollback();
        //     $respuesta = array(
        //         'mensaje' => 'Registros cargado correctamente',
        //         'documentos' => $docs,
        //         'status' => 200,
        //     );
        // } else {
        //     $this->db->trans_commit();
        //     $respuesta = array(
        //         'mensaje' => 'Registros:::',
        //         'documentos' => $docs,
        //         'whereDocumentos' => $whereDocumentos,
        //         'status' => 200,
        //     );
        // }

        // return $respuesta;

        $this->db->select('*')->from('documentos')->where('idformato', $idformato);
        // $publicidad = $this->db->get()->array();
        // $respuesta = array(
        //     'respuesta' => $publicidad,
        //     'status' => REST_Controller::HTTP_OK,
        //     $this->db->last_query()
        // );

       // return $respuesta;



        $query = $this->db->get();

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            $data = array($data);
            $respuesta = array(
                $this->db->last_query(),
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Sin agenda',
                'query' => $query,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }



    public function obtenerDocPdf($idformato)
    {

        $this->db->select('*')->from('documentos_formatos')->where('idformato', $idformato);
        $query = $this->db->get();

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            $data = array($data);
            $respuesta = array(
                $this->db->last_query(),
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Sin agenda',
                'query' => $query,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    ///Paginado
  
    public function paginado($datos)
    {
        $this->load->library('paginado');
        $paginado = $this->paginado->paginar($datos, 'view_documentos');

        $respuesta = array(
            'respuesta' =>  $paginado,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }



    public function eliminar_doc($datos)
    {

        $iddocumento = $datos['iddocumento'];
        $query = $this->db->select('ruta')->from('documentos')->where('iddocumento', $iddocumento)->limit(1)->get();
        $ruta = $query->row('ruta');

        if (file_exists("./assets/{$ruta}")) {
            unlink("./assets/{$ruta}");
        }
        $this->db->trans_begin();

        $delete = $this->db->delete('documentos', array('iddocumento' => $iddocumento));

        if ($this->db->trans_status() === false) {

            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en eliminación del documento.',
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Documento eliminado correctamente.',
                'status' => 200,
            );
        }

        return $respuesta;
    }

public function consultaDocumentos(){
        $where =  'formatos.idformato!=0';
        $query = $this->db->select("formatos.idformato,formatos.curp,documentos.ruta,documentos.periodo");
        $this->db->from('formatos');
        $this->db->where($where);
        $this->db->join('documentos', 'formatos.idformato=documentos.idformato');
        $query = $this->db->get();

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            $data = array($data);
            $respuesta = array(
                $this->db->last_query(),
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Sin agenda',
                'query' => $query,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
}

}
 