<?php

class Formato_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->helper('datos_generales');
    }

    // Función para obtener 
    public function obtenerFormatos()
    {
        $this->db
            ->select('*')
            ->from('formatos')
            ->where('idformato >= ', 1);

        return $consulta = $this->db->get()->result_array();
    }
///Paginado
    public function paginado($datos)
    {
        $this->load->library('paginado');
        $paginado = $this->paginado->paginar($datos, 'view_formatos');

        $respuesta = array(
            'respuesta' =>  $paginado,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }




 

    public function agregarFormato($datos)
    {
        $idformato = $datos['idformato'];
        $nivel = $datos['nivel'];

        $fecha = date("Y-m-d");
        if($idformato>0){
            $fecha = $datos['fecha'];
        }
        $data = array(
            'fecha' => $fecha,
            'nombre' => $datos['nombre'],
            'primer_apellido' => $datos['primer_apellido'],
            'segundo_apellido' => $datos['segundo_apellido'],
            'idusuario' => $datos['idusuario'],
            'curp' => $datos['curp'],
            'rfc' => $datos['rfc'],
            'homoclave' => $datos['homoclave'],
            'correo_institucional' => $datos['correo_institucional'],
            'correo_personal' => $datos['correo_personal'],
            'numero_casa' => $datos['numero_casa'],
            'numero_celular' => $datos['numero_celular'],
            'estado_civil' => $datos['estado_civil'],
            'regimen_matrimonial' => $datos['regimen_matrimonial'],
            'regimen_matrimonial_esp' => $datos['regimen_matrimonial_esp'],
            'pais_nacimiento' => $datos['pais_nacimiento'],
            'nacionalidad' => $datos['nacionalidad'],
            'observaciones' => $datos['observaciones'],
            'progreso' => 5,
            'tipo_formato' => $datos['tipo_formato'],
        );
        //****insertar progreso al agregar tamabien
        
        //    $porcentaje = array(
        //     'porcentaje' => 5,
        //  );  
        
        

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('formatos', $data);
            $id = $idformato;
                // if ($datos['progreso'] <10) {
                // $this->db->where('idformato', $idformato);
                // $this->db->update('progreso', $porcentaje);
                // }
        } else {
            $this->db->insert('formatos', $data);
            $id = $this->db->insert_id();


            $data2 = array(
                'idformato' => $id,
            );
          


            
            //Nivel 6 ---------------------------------------------------
            if ($nivel == 6) {

                $dataNivel6 = array(
                    'idformato' => $id,
                    'ninguno' => 1,
                    'progreso' => 5,
                );
               $dataNivel6_2 = array(
                    'idformato' => $id,
                    'ninguno' => 1,
                   'progreso' => 4,
               );
               $dataNivel6_3 = array(
                   'idformato' => $id,
                    'ninguno' => 1,
                   'progreso' => 1,
               );
                $this->db->insert('2_domicilio_declarante', $data2);
                $this->db->insert('3_datos_curriculares', $data2);
                $this->db->insert('4_datos_empleo', $data2);
                $this->db->insert('5_experiencia_laboral', $data2);
                $this->db->insert('6_datos_pareja', $dataNivel6);
                $this->db->insert('7_datos_dependiente', $dataNivel6);
                $this->db->insert('8_ingresos_netos', $data2);
                $this->db->insert('9_bienes_inmuebles', $dataNivel6);
                $this->db->insert('10_vehiculos', $dataNivel6);
                $this->db->insert('11_bienes_muebles', $dataNivel6);
                $this->db->insert('12_inversiones', $dataNivel6);
                $this->db->insert('13_adeudos', $dataNivel6);
                $this->db->insert('14_prestamos', $dataNivel6);
                $this->db->insert('1_ii_participacion_empresas', $dataNivel6);
                $this->db->insert('2_ii_toma_decisiones', $dataNivel6);
                $this->db->insert('3_ii_apoyos', $dataNivel6);
                $this->db->insert('4_ii_representacion', $dataNivel6);
                $this->db->insert('5_ii_clientes', $dataNivel6);
                $this->db->insert('6_ii_beneficios', $dataNivel6_2);
                $this->db->insert('7_ii_fideicomisos', $dataNivel6_3);
            }else{
            $this->db->insert('2_domicilio_declarante', $data2);
            $this->db->insert('3_datos_curriculares', $data2);
            $this->db->insert('4_datos_empleo', $data2);
            $this->db->insert('5_experiencia_laboral', $data2);
            $this->db->insert('6_datos_pareja', $data2);
            $this->db->insert('7_datos_dependiente', $data2);
            $this->db->insert('8_ingresos_netos', $data2);
            $this->db->insert('9_bienes_inmuebles', $data2);
            $this->db->insert('10_vehiculos', $data2);
            $this->db->insert('11_bienes_muebles', $data2);
            $this->db->insert('12_inversiones', $data2);
            $this->db->insert('13_adeudos', $data2);
            $this->db->insert('14_prestamos', $data2);
            $this->db->insert('1_ii_participacion_empresas', $data2);
            $this->db->insert('2_ii_toma_decisiones', $data2);
            $this->db->insert('3_ii_apoyos', $data2);
            $this->db->insert('4_ii_representacion', $data2);
            $this->db->insert('5_ii_clientes', $data2);
            $this->db->insert('6_ii_beneficios', $data2);
            $this->db->insert('7_ii_fideicomisos', $data2); 
            }
  

           

            //$this->db->insert('progreso', $porcentaje);
        } 

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            // $respuesta = array(
            //     'mensaje' => 'Inserción correcta',
            //     'status' => 200,
            //     'idF:' => $id,
            // );
            $respuesta = $id;
        }
        return $respuesta;
    }




    


    public function obtenerFormato()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('formatos', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'status' => 400,
            );
        }
        return $respuesta;
    }


    public function obtenerTipoFormato()
    {
        $idusuario = $this->uri->segment(3);
        $where =  array('idusuario' => $idusuario);
        $query = $this->db->select("*")->get_where('view_declaraciones', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'No hay registros en la view_declaraciones',
                'registro' => 'SIN REGISTROS',
                'status' => 200,
            );
        }
        return $respuesta;
    }



    public function obtenerReportePDF($idformato)
    {
        $this->db->select('*')->from('formatos')->where('idformato', $idformato);

      //  $this->db->select('*')->from('view_formatos')->where('idformato', $idformato);
        $consulta = $this->db->get()->result_array();
        $datos = array(
            'idformato' => $consulta[0]["idformato"],
            'fecha' => $consulta[0]["fecha"],
            'nombre' => $consulta[0]['nombre'],
            'primer_apellido' => $consulta[0]['primer_apellido'],
            'segundo_apellido' => $consulta[0]['segundo_apellido'],
            'idusuario' => $consulta[0]['idusuario'],
            'curp' => $consulta[0]['curp'],
            'rfc' => $consulta[0]['rfc'],
            'homoclave' => $consulta[0]['homoclave'],
            'correo_institucional' => $consulta[0]['correo_institucional'],
            'correo_personal' => $consulta[0]['correo_personal'],
            'numero_casa' => $consulta[0]['numero_casa'],
            'numero_celular' => $consulta[0]['numero_celular'],
            'estado_civil' => $consulta[0]['estado_civil'],
            'regimen_matrimonial' => $consulta[0]['regimen_matrimonial'],
            'regimen_matrimonial_esp' => $consulta[0]['regimen_matrimonial_esp'],
            'pais_nacimiento' => $consulta[0]['pais_nacimiento'],
            'nacionalidad' => $consulta[0]['nacionalidad'],
            'observaciones' => $consulta[0]['observaciones'],

            'calle' => $consulta[0]['calle'],
            'numero_ext' => $consulta[0]['numero_ext'],
            'numero_int' => $consulta[0]['numero_int'],
            'localidad' => $consulta[0]['localidad'],
            'codigo_postal' => $consulta[0]['codigo_postal'],
            'aclaraciones' => $consulta[0]['aclaraciones'],
            'municipio_estado' => $consulta[0]['municipio_estado'],
            'entidad_pais' => $consulta[0]['entidad_pais'],
            'mexico_extranjero' => $consulta[0]['mexico_extranjero'],

        );
         $pdf = new Pdf_helper_datos_generales();
         $pdf->generarPDF($datos);
    }



    public function obtenerProgreso($idformato)
    {
        // $this->db->select('confirmacion,confirmacion2023 , sum(progreso_1 + progreso_2 + progreso_3 + progreso_4 + progreso_5 + progreso_6 + progreso_7 + progreso_8 + progreso_9 + progreso_10 + progreso_11 + progreso_12 + progreso_13 + progreso_14 + progreso_1_ii + progreso_2_ii + progreso_3_ii + progreso_4_ii + progreso_5_ii + progreso_6_ii + progreso_7_ii) as suma, CONCAT(idformato,",",progreso_1, ",", progreso_2, ",", progreso_3, ",", progreso_4, ",", progreso_5, ",", progreso_6, ",", progreso_7, ",", progreso_8, ",", progreso_9, ",", progreso_10, ",", progreso_11, ",", progreso_12, ",", progreso_13, ",", progreso_14, ",", progreso_1_ii, ",", progreso_2_ii, ",", progreso_3_ii, ",", progreso_4_ii, ",", progreso_5_ii, ",", progreso_6_ii, ",", progreso_7_ii) as cadena')->from('view_progreso')->where('idformato', $idformato);

        $this->db->select('confirmacion,confirmacion2023,confirmacion2024 , sum(progreso_1 + progreso_2 + progreso_3 + progreso_4 + progreso_5 + progreso_6 + progreso_7 + progreso_8 + progreso_9 + progreso_10 + progreso_11 + progreso_12 + progreso_13 + progreso_14 + progreso_1_ii + progreso_2_ii + progreso_3_ii + progreso_4_ii + progreso_5_ii + progreso_6_ii + progreso_7_ii) as suma, CONCAT(idformato,",",progreso_1, ",", progreso_2, ",", progreso_3, ",", progreso_4, ",", progreso_5, ",", progreso_6, ",", progreso_7, ",", progreso_8, ",", progreso_9, ",", progreso_10, ",", progreso_11, ",", progreso_12, ",", progreso_13, ",", progreso_14, ",", progreso_1_ii, ",", progreso_2_ii, ",", progreso_3_ii, ",", progreso_4_ii, ",", progreso_5_ii, ",", progreso_6_ii, ",", progreso_7_ii) as cadena')->from('view_progreso')->where('idformato', $idformato);
        $publicidad = $this->db->get()->row();
        $respuesta = array(
            'respuesta' => $publicidad,
            'status' => REST_Controller::HTTP_OK,
            $this->db->last_query()
        );

        return $respuesta;
    }

    public function obtenerTipoUsuario($idusuario)
    {
        $this->db->select('*')->from('view_formato_usuarios')->where('idusuario', $idusuario);
        $publicidad = $this->db->get()->row();
        $respuesta = array(
            'respuesta' => $publicidad,
            'status' => REST_Controller::HTTP_OK,
            $this->db->last_query()
        );

        return $respuesta;
    }


    public function tiposUsuario($idusuario)
    {
        $this->db->select('*')->from('usuarios')->where('idusuario', $idusuario);
        $publicidad = $this->db->get()->row();
        $respuesta = array(
            'respuesta' => $publicidad,
            'status' => REST_Controller::HTTP_OK,
            $this->db->last_query()
        );

        return $respuesta;
    }

    public function obtenerSecciones()
    {
        $this->db->select('*')->from('secciones');
        $sector = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $sector,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }



    public function obtenerNivel($idusuario)
    {
        $this->db->select('*')->from('view_empleados')->where('idusuario', $idusuario);;

        $publicidad = $this->db->get()->row();
        $respuesta = array(
            'respuesta' => $publicidad,
            'status' => REST_Controller::HTTP_OK,
            $this->db->last_query()
        );

        return $respuesta;
    }


    public function Enviar($idformato)
    {
        // $idformato = $datos['idformato'];
      date_default_timezone_set('America/Matamoros');
      $fecha = date("Y-m-d H:i:s");
      //PARA GUARDAR FECHA FIJA:::::::::::--->      $fecha = '2023-05-31 15:00:00';
        $data = array(

            // 'confirmacion2023' => 1,
            // 'fecha_confirmacion23' => $fecha,
            'confirmacion2024' => 1,
            'fecha_confirmacion24' => $fecha,
        );
        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('formatos', $data);
            $id = $idformato;
        } 
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function EnviarConclusion($idformato)
    {
        // $idformato = $datos['idformato'];
        date_default_timezone_set('America/Matamoros');
        $fecha = date("Y-m-d H:i:s");
        //--- $fecha = '2023-05-31 15:00:00';
        $data = array(
            // 'confirmacion' => 1,
            //'fecha_confirmacion' => $fecha,
            'servidor_inactivo' => 1,
           //  'confirmacion2023' => 1,
           // 'fecha_confirmacion23' => $fecha,
            'servidor_baja_fecha' => $fecha,
        );
        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('formatos', $data);
            $id = $idformato;
        }
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }





    public function CadenaStr()
    {
        // $where =  'formatos.curp != "" and view_empleados.nivel!= 6 and formatos.servidor_inactivo=0';
        // $query = $this->db->select("view_empleados.clave, view_empleados.secretaria, view_empleados.puesto, view_empleados.nombre_empleado, formatos.idformato,formatos.tipo_formato,formatos.idusuario,formatos.nombre,formatos.primer_apellido,formatos.segundo_apellido,formatos.curp,view_empleados.nivel");
        // $this->db->from('formatos');
        // $this->db->where($where);
        // $this->db->join('view_empleados', 'formatos.idusuario=view_empleados.idusuario');
        // $this->db->order_by('formatos.idusuario', 'ASC');
        // $query = $this->db->get();



      
        $where =  'nivel!= 6';
        //$this->db->distinct();
        $query = $this->db->select(" fecha, clave, secretaria, puesto, nombre_empleado,idformato,tipo_formato,idusuario,nombre,primer_apellido,segundo_apellido,curp,nivel");
        $this->db->from('view_seleccion');
        $this->db->where($where);
        $this->db->group_by('idformato');
        $this->db->order_by('idusuario', 'ASC');
        $query = $this->db->get();

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            $respuesta = array(
                $this->db->last_query(),
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Sin agenda',
                'query' => $query,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function obtenerFiltro()
    {
        $letra1 = $this->uri->segment(3);
       // $letra2 = $this->uri->segment(4);
       // $mes = $this->uri->segment(5);
        $where =  'formatos.curp like "' . $letra1 . '%" and view_empleados.nivel!= 6';
       // $where =  'curp like "' . $letra1. '%"  and curp like "__' . $letra2 . '%"  and curp like "______'.$mes.'%"';
        $query = $this->db->select("formatos.idformato,formatos.tipo_formato,formatos.idusuario,formatos.nombre,formatos.primer_apellido,formatos.segundo_apellido,formatos.curp");
        $this->db->from('formatos');
        $this->db->join('view_empleados', 'formatos.idusuario=view_empleados.idusuario');   
        $this->db->where($where);
        $query = $this->db->get();

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            $respuesta = array(
                $this->db->last_query(),
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Sin agenda',
                'query' => $query,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    

    public function Reporte_add()
    {

        $num = $this->uri->segment(3);


        if ($num == '2023') {
        $where6 =  'activo=1';
        $query6 = $this->db->select("*");
        $this->db->from('view_prestamos_add');
        $this->db->where($where6);
        $query6 = $this->db->get();
        }
        if ($num == '2022') {
            $where6 =  'activo=1';
            $query6 = $this->db->select("*");
            $this->db->from('view_prestamos_add2022');
            $this->db->where($where6);
            $query6 = $this->db->get();
        }


        if ($num == '2023') {
        $where5 =  'activo=1';
        $query5 = $this->db->select("*");
        $this->db->from('view_adeudos_add');
        $this->db->where($where5);
        $query5 = $this->db->get();
        }

        if ($num == '2022') {
            $where5 =  'activo=1';
            $query5 = $this->db->select("*");
            $this->db->from('view_adeudos_add2022');
            $this->db->where($where5);
            $query5 = $this->db->get();
        }

        if ($num == '2023') {
        $where4 =  'activo=1';
        $query4 = $this->db->select("*");
        $this->db->from('view_inversiones_add');
        $this->db->where($where4);
        $query4 = $this->db->get();
        }
        if ($num == '2022') {
            $where4 =  'activo=1';
            $query4 = $this->db->select("*");
            $this->db->from('view_inversiones_add2022');
            $this->db->where($where4);
            $query4 = $this->db->get();
        }


        if ($num == '2023') {
        $where3 =  'activo=1';
        $query3 = $this->db->select("*");
        $this->db->from('view_muebles_add');
        $this->db->where($where3);
        $query3 = $this->db->get();
        }
        if ($num == '2022') {
            $where3 =  'activo=1';
            $query3 = $this->db->select("*");
            $this->db->from('view_muebles_add2022');
            $this->db->where($where3);
            $query3 = $this->db->get();
        }


        if ($num == '2023') {
        $where2 =  'activo=1';
        $query2 = $this->db->select("*");
        $this->db->from('view_vehiculo_add');
        $this->db->where($where2);
         $query2 = $this->db->get();
        }
        if ($num == '2022') {
            $where2 =  'activo=1';
            $query2 = $this->db->select("*");
            $this->db->from('view_vehiculo_add2022');
            $this->db->where($where2);
            $query2 = $this->db->get();
        }

        if ($num == '2023') {
            $where =  'activo = 1';
            $query = $this->db->select("*");
            $this->db->from('view_inmuebles_add');
            $this->db->where($where);
            $query = $this->db->get();
        }
        if ($num == '2022') {
            $where =  'activo = 1';
            $query = $this->db->select("*");
            $this->db->from('view_inmuebles_add2022');
            $this->db->where($where);
            $query = $this->db->get();
        }

        

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array() ;
            $data2 =  $query2->result_array();
            $data3 =  $query3->result_array();
            $data4 =  $query4->result_array();
            $data5 =  $query5->result_array();
            $data6 =  $query6->result_array();
            $data = array($data, $data2, $data3, $data4, $data5, $data6);
            $respuesta = array(
                $this->db->last_query(),
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Sin agenda',
                'query' => $query,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }



    public function Reporte()
    {
        $where =  'view_excel.servidor_inactivo=0';
        $query = $this->db->select("*");
        $this->db->from('view_excel');
        $this->db->where($where);
    //    $this->db->order_by('formatos.idusuario', 'ASC');
        $query = $this->db->get();

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            $respuesta = array(
                $this->db->last_query(),
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Sin agenda',
                'query' => $query,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function Reporte22_23()
    {
        $num = $this->uri->segment(3);
        if($num=='2023'){
            $where =  'idformato >= 1 ';
            $query = $this->db->select("*");
            $this->db->from('view_seleccion_2023');
            $this->db->where($where);
            $query = $this->db->get();
        }
        if ($num == '2022') {
            $where =  'idformato >= 1 ';
            $query = $this->db->select("*");
            $this->db->from('view_seleccion_2022');
            $this->db->where($where);
            $query = $this->db->get();
        }
        
        

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            $respuesta = array(
                $this->db->last_query(),
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Sin agenda',
                'query' => $query,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }



    public function obtenerTiposSector()
    {
        $this->db->select('*')->from('tipos_sector');
        $sector = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $sector,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function cambiar_estado($datos)
    {
        date_default_timezone_set('America/Matamoros');
       // $fecha = date("Y-m-d");
       
     
       
        $idformato = $datos['idformato'];
        $value = $datos['value'];

  // if($datos['fecha']== 'NULA'){
          
   //          $fecha = date("Y-m-d H:i:s");
   // } else{
              $fecha = $datos['fecha'];
   // }   

        if (isset($idformato)) {

            $update = $this->db->where('idformato', $idformato)->update('formatos', array('servidor_inactivo' => $value));
            if($value==1){
                $update = $this->db->where('idformato', $idformato)->update('formatos', array('servidor_baja_fecha' => $fecha));
            }
            if ($value==0) {
                $update = $this->db->where('idformato', $idformato)->update('formatos', array( 'servidor_alta_fecha' => $fecha));
            }
            
            if ($update) {
                $respuesta = array(
                    'mensaje' => 'Actualizacion de estado correcta',
                    'status' => 200,
                    'value:' => $value,
                    'query:' =>  $this->db->last_query()
                );
            } else {
                $respuesta = array(
                    'mensaje' => 'Error en actualizacion de estado',
                    'error' => $this->db->error(),
                    'status' => 409,
                );
            }
        } else {
            $respuesta = array(
                'mensaje' => 'Error interno',
                'status' => 400,
            );
        }
        return $respuesta;
    }





    public function Reporte_add_2()
    {

        $where7 =  'view_empleados.nivel!= 6 and 7_ii_fideicomisos_add.activo=1';
        $query7 = $this->db->select("formatos.idformato,
7_ii_fideicomisos_add.participacion AS participacion_i7_add,
7_ii_fideicomisos_add.tipo_fideicomiso AS tipo_fideicomiso_i7_add,7_ii_fideicomisos_add.tipo_participacion AS tipo_participacion_i7_add,7_ii_fideicomisos_add.rfc_fideicomiso AS rfc_fideicomiso_i7_add,
7_ii_fideicomisos_add.fideicomitente AS fideicomitente_i7_add,7_ii_fideicomisos_add.nombre_fideicomitente AS nombre_fideicomitente_i7_add,7_ii_fideicomisos_add.rfc_fideicomitente AS rfc_fideicomitente_i7_add,
7_ii_fideicomisos_add.nombre_fiduciario AS nombre_fiduciario_i7_add,7_ii_fideicomisos_add.rfc_fiduciario AS rfc_fiduciario_i7_add,7_ii_fideicomisos_add.fideicomisario AS fideicomisario_i7_add,
7_ii_fideicomisos_add.nombre_fideicomisario AS nombre_fideicomisario_i7_add,7_ii_fideicomisos_add.rfc_fideicomisario AS rfc_fideicomisario_i7_add,7_ii_fideicomisos_add.sector_productivo AS sector_productivo_i7_add,
7_ii_fideicomisos_add.sector_productivo_esp AS sector_productivo_esp_i7_add,7_ii_fideicomisos_add.mexico_extranjero AS mexico_extranjero_i7_add,
7_ii_fideicomisos_add.aclaraciones AS aclaraciones_i7_add 
        ");
        $this->db->from('formatos');
        $this->db->where($where7);
        $this->db->join('view_empleados', 'formatos.idusuario=view_empleados.idusuario');
        $this->db->join('7_ii_fideicomisos_add', 'formatos.idformato=7_ii_fideicomisos_add.idformato');
        $query7 = $this->db->get();


        $where6 =  'view_empleados.nivel!= 6 and 6_ii_beneficios_add.activo=1';
        $query6 = $this->db->select("formatos.idformato,
6_ii_beneficios_add.tipo_beneficio AS tipo_beneficio_i6_add,6_ii_beneficios_add.beneficiario AS beneficiario_i6_add,6_ii_beneficios_add.otorgante AS otorgante_i6_add,
6_ii_beneficios_add.nombre_otorgante AS nombre_otorgante_i6_add,
6_ii_beneficios_add.rfc AS rfc_i6_add,6_ii_beneficios_add.forma_recepcion AS forma_recepcion_i6_add,6_ii_beneficios_add.beneficio AS beneficio_i6_add,
6_ii_beneficios_add.monto_mensual AS monto_mensual_i6_add,
6_ii_beneficios_add.tipo_moneda AS tipo_moneda_i6_add,6_ii_beneficios_add.sector_productivo AS sector_productivo_i6_add,
6_ii_beneficios_add.aclaraciones AS aclaraciones_i6_add,
6_ii_beneficios_add.sector_productivo_esp AS sector_productivo_esp_i6_add,6_ii_beneficios_add.tipo_beneficio_esp AS tipo_beneficio_esp_i6_add
        ");
        $this->db->from('formatos');
        $this->db->where($where6);
        $this->db->join('view_empleados', 'formatos.idusuario=view_empleados.idusuario');
        $this->db->join('6_ii_beneficios_add', 'formatos.idformato=6_ii_beneficios_add.idformato');
        $query6 = $this->db->get();


        $where5 =  'view_empleados.nivel!= 6 and 5_ii_clientes_add.activo=1';
        $query5 = $this->db->select("formatos.idformato,
5_ii_clientes_add.actividad AS actividad_i5_add,5_ii_clientes_add.declarante AS declarante_i5_add,5_ii_clientes_add.nombre_empresa AS nombre_empresa_i5_add,
5_ii_clientes_add.rfc_empresa AS rfc_empresa_i5_add,5_ii_clientes_add.cliente_principal AS cliente_principal_i5_add,5_ii_clientes_add.razon_social AS razon_social_i5_add,
5_ii_clientes_add.rfc_razon AS rfc_razon_i5_add,
5_ii_clientes_add.sector_productivo AS sector_productivo_i5_add,5_ii_clientes_add.sector_productivo_esp AS sector_productivo_esp_i5_add,
5_ii_clientes_add.monto_mensual AS monto_mensual_i5_add,
5_ii_clientes_add.mexico_extranjero AS mexico_extranjero_i5_add,5_ii_clientes_add.entidad_pais AS entidad_pais_i5_add,
,5_ii_clientes_add.aclaraciones AS aclaraciones_i5_add
        ");
        $this->db->from('formatos');
        $this->db->where($where5);
        $this->db->join('view_empleados', 'formatos.idusuario=view_empleados.idusuario');
        $this->db->join('5_ii_clientes_add', 'formatos.idformato=5_ii_clientes_add.idformato');
        $query5 = $this->db->get();

        $where4 =  'view_empleados.nivel!= 6 and 4_ii_representacion_add.activo=1';
        $query4 = $this->db->select("formatos.idformato,
4_ii_representacion_add.declarante AS declarante_i4_add,4_ii_representacion_add.tipo_representacion AS tipo_representacion_i4_add,
4_ii_representacion_add.fecha_inicio AS fecha_inicio_i4_add,4_ii_representacion_add.representante AS representante_i4_add,
4_ii_representacion_add.nombre_representante AS nombre_representante_i4_add,
4_ii_representacion_add.rfc AS rfc_i4_add,4_ii_representacion_add.remuneracion AS remuneracion_i4_add,4_ii_representacion_add.monto_mensual AS monto_mensual_i4_add,
4_ii_representacion_add.mexico_extranjero AS mexico_extranjero_i4_add,
4_ii_representacion_add.entidad_pais AS entidad_pais_i4_add,4_ii_representacion_add.sector_productivo AS sector_productivo_i4_add,
4_ii_representacion_add.aclaraciones AS aclaraciones_i4_add,
4_ii_representacion_add.sector_productivo_esp AS sector_productivo_esp_i4_add
        ");
        $this->db->from('formatos');
        $this->db->where($where4);
        $this->db->join('view_empleados', 'formatos.idusuario=view_empleados.idusuario');
        $this->db->join('4_ii_representacion_add', 'formatos.idformato=4_ii_representacion_add.idformato');
        $query4 = $this->db->get();



        $where3 =  'view_empleados.nivel!= 6 and 3_ii_apoyos_add.activo=1';
        $query3 = $this->db->select("formatos.idformato,
3_ii_apoyos_add.beneficiario AS beneficiario_i3_add,3_ii_apoyos_add.nombre_programa AS nombre_programa_i3_add,
3_ii_apoyos_add.institucion AS institucion_i3_add,3_ii_apoyos_add.nivel_gobierno AS nivel_gobierno_i3_add,3_ii_apoyos_add.tipo_apoyo AS tipo_apoyo_i3_add,3_ii_apoyos_add.tipo_apoyo_esp AS tipo_apoyo_esp_i3_add,
3_ii_apoyos_add.forma_recepcion AS forma_recepcion_i3_add,3_ii_apoyos_add.monto_apoyo AS monto_apoyo_i3_add,3_ii_apoyos_add.especifique_apoyo AS especifique_apoyo_i3_add,
3_ii_apoyos_add.aclaraciones AS aclaraciones_i3_add
        ");
        $this->db->from('formatos');
        $this->db->where($where3);
        $this->db->join('view_empleados', 'formatos.idusuario=view_empleados.idusuario');
        $this->db->join('3_ii_apoyos_add', 'formatos.idformato=3_ii_apoyos_add.idformato');
        $query3 = $this->db->get();




        $where2 =  'view_empleados.nivel!= 6 and 2_ii_toma_decisiones_add.activo=1';
        $query2 = $this->db->select("formatos.idformato,
         2_ii_toma_decisiones_add.declarante AS declarante_i2_add,
2_ii_toma_decisiones_add.nombre_institucion AS nombre_institucion_i2_add,2_ii_toma_decisiones_add.rfc AS rfc_i2_add,2_ii_toma_decisiones_add.puesto AS puesto_i2_add,
2_ii_toma_decisiones_add.tipo_institucion AS tipo_institucion_i2_add,2_ii_toma_decisiones_add.tipo_institucion_esp AS tipo_institucion_esp_i2_add,
2_ii_toma_decisiones_add.fecha_inicio AS fecha_inicio_i2_add,2_ii_toma_decisiones_add.remuneracion AS remuneracion_i2_add,2_ii_toma_decisiones_add.monto_mensual AS monto_mensual_i2_add,
2_ii_toma_decisiones_add.mexico_extranjero AS mexico_extranjero_i2_add,2_ii_toma_decisiones_add.entidad_pais AS entidad_pais_i2_add,
2_ii_toma_decisiones_add.aclaraciones AS aclaraciones_i2_add
        ");
        $this->db->from('formatos');
        $this->db->where($where2);
        $this->db->join('view_empleados', 'formatos.idusuario=view_empleados.idusuario');
        $this->db->join('2_ii_toma_decisiones_add', 'formatos.idformato=2_ii_toma_decisiones_add.idformato');
        $query2 = $this->db->get();


        $where =  'view_empleados.nivel!= 6 and 1_ii_participacion_empresas_add.activo=1';
        $query = $this->db->select("formatos.idformato,
        1_ii_participacion_empresas_add.declarante AS declarante_i1_add,
        1_ii_participacion_empresas_add.nombre_empresa AS nombre_empresa_i1_add,1_ii_participacion_empresas_add.rfc AS rfc_i1_add,
        1_ii_participacion_empresas_add.porcentaje AS porcentaje_i1_add,1_ii_participacion_empresas_add.tipo_participacion AS tipo_participacion_i1_add,
        1_ii_participacion_empresas_add.remuneracion AS remuneracion_i1_add,1_ii_participacion_empresas_add.monto_mensual AS monto_mensual_i1_add,
        1_ii_participacion_empresas_add.mexico_extranjero AS mexico_extranjero_i1_add,1_ii_participacion_empresas_add.entidad_pais AS entidad_pais_i1_add,
        1_ii_participacion_empresas_add.sector_productivo AS sector_productivo_i1_add,
        1_ii_participacion_empresas_add.aclaraciones AS aclaraciones_i1_add,1_ii_participacion_empresas_add.tipo_participacion_esp AS tipo_participacion_es_i1_add,
        1_ii_participacion_empresas_add.sector_productivo_esp AS sector_productivo_esp_i1_add
        ");
        $this->db->from('formatos');
        $this->db->where($where);
        $this->db->join('view_empleados', 'formatos.idusuario=view_empleados.idusuario');
        $this->db->join('1_ii_participacion_empresas_add', 'formatos.idformato=1_ii_participacion_empresas_add.idformato');
        $query = $this->db->get();

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            $data2 =  $query2->result_array();
            $data3 =  $query3->result_array();
            $data4 =  $query4->result_array();
            $data5 =  $query5->result_array();
            $data6 =  $query6->result_array();
            $data7 =  $query7->result_array();
            $data = array($data, $data2, $data3, $data4, $data5, $data6, $data7);
            $respuesta = array(
                $this->db->last_query(),
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Sin agenda',
                'query' => $query,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }
}
