<?php
class Registro_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('registro_model');
        $this->load->helper('correo');
        $this->load->helper('correo2');
    }

    // Función para obtener la lista de tipos de usuarios


    public function obtenerEmpleado()
    {
        $Empleado = $this->uri->segment(3);
        $where =  array('clave' => $Empleado);
        $query = $this->db->select("*")->get_where('empleados', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'query' => $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => null,
                'query' => $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtenerFormato()
    {
        $clave = $this->uri->segment(3);
        $where =  array('clave' => $clave);
        $this->db->order_by('idformato', 'DESC');
        $query = $this->db->select("*")->get_where('view_formato_usuarios', $where);
        
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'query' => $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => null,
                'query' => $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function obtenerRfc()
    {
        $rfc = $this->uri->segment(3);
        $clave = $this->uri->segment(4);
        $where =  array('rfc' => $rfc, 'clave' => $clave);
       // $this->db->order_by('idformato', 'DESC');
        $query = $this->db->select("*")->get_where('view_formato_usuarios', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'query' => $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => null,
                'query' => $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function empleadoRegistrado()
    {
        $Empleado = $this->uri->segment(3);
        $where =  array('clave' => $Empleado);
        $query = $this->db->select("*")->get_where('view_empleados', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'query' => $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => null,
                'query' => $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }



    public function agregarRegistro($datos)
    {
        //Se actualizo la forma de la fecha de alta de los usuarios
        date_default_timezone_set('America/Matamoros');
        $fecha = date("Y-m-d H:i:s");

        $idusuario = $datos['idusuario'];
        $password = $datos['password'];
        $password2 = $datos['password'];

        $correo = $datos["correo"];
        $tipo = $datos['idtipo_usuario'];
        if (!empty($password)) {
            $password = password_hash($password, PASSWORD_BCRYPT);
        }
        $data = array(
            'tipo' =>  $datos['idtipo_usuario'],
            'nombre' => $datos['nombre'],
            'correo' => $datos['correo'],
            'password' => $password,
            'activo' => $datos['activo'],
            'clave' => $datos['numero_empleado'],
            'fecha' => $fecha,
        );

        $dataCorreo = array(
            'tipo' =>  $datos['idtipo_usuario'],
            'nombre' => $datos['nombre'],
            'correo' => $datos['correo'],
            'password' => $password,
            'activo' => $datos['activo'],
            'password2' => $password2,
        );


            

        $existe = (bool) $this->db->select('idusuario')->from('usuarios')->where('correo', $correo)->count_all_results();

        if($existe!=true){
            $this->db->insert('usuarios', $data);
            $id = $this->db->insert_id();
        }


        if (
            $this->db->trans_status() === false
        ) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            //Enviando el correo con sus credenciales
            correo($dataCorreo);

            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'Existe:', $existe,
                'status' => 200,
            );
        }
        return $respuesta;
    }



    public function correo($data)
    {
        $correo = $data["correo"];
        $idusuario = $data["idusuario"];
        if ($idusuario > 0) {
            $this->db->where_not_in('idusuario', [$idusuario]);
        }
        $existe = (bool) $this->db->select('idusuario')->from('usuarios')->where('correo', $correo)->count_all_results();

        $respuesta = array(
            'respuesta' => $existe,
            'status' => REST_Controller::HTTP_ACCEPTED
        );
        return $respuesta;
    }

    // public function correo2($data)
    // {
    //     $correo = $data["correo"];
    //     $idusuario = $data["idusuario"];
    //     if ($idusuario > 0) {
    //         $this->db->where_not_in('idusuario', [$idusuario]);
    //     }
    //     $existe = (bool) $this->db->select('idusuario')->from('usuarios')->where('correo', $correo)->count_all_results();

    //     $respuesta = array(
    //         'respuesta' => $existe,
    //         'status' => REST_Controller::HTTP_ACCEPTED
    //     );
    //     return $respuesta;
    // }



    public function editarRegistro($datos)
    {
        $idusuario = $datos['idusuario'];
        $password = $datos['password'];
        $password2 = $datos['password'];

        $correo = $datos["correo"];
        $tipo = $datos['idtipo_usuario'];
        if (!empty($password)) {
            $password = password_hash($password, PASSWORD_BCRYPT);
        }
        $data = array(
            'correo' => $correo,
            'password' => $password,
        );
        $dataCorreo = array(
            'tipo' =>  $datos['idtipo_usuario'],
            'nombre' => $datos['nombre'],
            'correo' => $datos['correo'],
            'password' => $password,
            'activo' => $datos['activo'],
            'password2' => $password2,
        );

        $existe = (bool) $this->db->select('idusuario')->from('usuarios')->where('idusuario', $idusuario)->count_all_results();

        if ($existe == true) {
            $this->db->where('idusuario', $idusuario);
            $this->db->update('usuarios', $data);
        }
        if (
            $this->db->trans_status() === false
        ) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en edición.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            //Enviando el correo con sus credenciales
            correo2($dataCorreo);
            
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Edición correcta',
                // 'last: ', $this->db->last_query(),
                'Existe:', $existe,
                'status' => 200,
            );
        }
        return $respuesta;
    }
    
}
 